/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.persistence;

import org.jboss.managed.api.ManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;

/**
 * Create a xml representation of a Managed Object.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 87425 $
 */
public class ManagedObjectPeristenceHandler
{
   
   /** . */
   private final ManagedObjectPersistencePlugin plugin;

   public ManagedObjectPeristenceHandler()
   {
      this.plugin = new DelegatingPersistencePlugin();
   }
   
   /**
    * Create the persistence meta data for a ManagedObject.
    * 
    * @param mo the managed object
    * @return the persistence meta data
    */
   public PersistedManagedObject createPersistenceMetaData(ManagedObject mo)
   {
      if(mo == null)
         throw new IllegalArgumentException("Null managedObject.");
      
      return getPlugin().createPersistedManagedObject(mo);
   }
   
   /**
    * Process a managed object.
    * 
    * @param moElement the xml meta data.
    * @param mo the managed object
    * @return isModified
    */
   public void processManagedObject(PersistedManagedObject persisted, ManagedObject mo)
   {
      if(persisted == null)
         throw new IllegalArgumentException("Null rootElement.");
      if(mo == null)
         throw new IllegalArgumentException("null managedObject");
      
      getPlugin().createPersistedManagedObject(persisted, mo);
   }

   protected ManagedObjectPersistencePlugin getPlugin()
   {
      return this.plugin;
   }
   
}
