/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.system.server.profileservice.persistence.AbstractValuePersistence;
import org.jboss.system.server.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedObjectPersistencePlugin
implements ManagedObjectPersistencePlugin {
    private static final Logger log = Logger.getLogger(AbstractManagedObjectPersistencePlugin.class);
    private AbstractValuePersistence valuePersistence;

    @Override
    public AbstractValuePersistence getValuePersistence() {
        return this.valuePersistence;
    }

    @Override
    public void setValuePersistence(AbstractValuePersistence valuePersistence) {
        if (valuePersistence == null) {
            throw new IllegalArgumentException("null value persistence.");
        }
        this.valuePersistence = valuePersistence;
    }

    public abstract String getType();

    @Override
    public PersistedManagedObject createPersistedManagedObject(ManagedObject mo) {
        PersistedManagedObject persisted = new PersistedManagedObject();
        persisted.setOriginalName(mo.getName());
        return this.createPersistedManagedObject(persisted, mo);
    }

    @Override
    public PersistedManagedObject createPersistedManagedObject(PersistedManagedObject persisted, ManagedObject mo) {
        Class<?> attachment;
        if (persisted == null) {
            throw new IllegalArgumentException("Null persisted managed object.");
        }
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object");
        }
        String className = mo.getAttachmentName();
        if (mo.getAttachment() != null && !(className = (attachment = mo.getAttachment().getClass()).getName()).equals(mo.getAttachmentName())) {
            persisted.setTemplateName(mo.getAttachmentName());
        }
        if (persisted.getOriginalName() == null) {
            persisted.setOriginalName(mo.getName());
        }
        persisted.setName(mo.getName());
        persisted.setClassName(className);
        return persisted;
    }

    protected void processProperties(PersistedManagedObject persisted, ManagedObject mo) {
        boolean trace = log.isTraceEnabled();
        this.processProperties(persisted, mo, trace);
    }

    protected void processProperties(PersistedManagedObject persisted, ManagedObject mo, boolean trace) {
        if (persisted == null) {
            throw new IllegalArgumentException("Null persisted object");
        }
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object.");
        }
        Map<String, PersistedProperty> properties = AbstractManagedObjectPersistencePlugin.getPersistedProperties(persisted);
        for (String propertyName : mo.getPropertyNames()) {
            ManagedProperty property = mo.getProperty(propertyName);
            PersistedProperty persistedProperty = properties.get(propertyName);
            if (persistedProperty == null) {
                persistedProperty = this.createPersistedProperty(property);
            }
            if (!this.processProperty(property, persistedProperty, trace)) continue;
            persisted.getProperties().add(persistedProperty);
        }
    }

    protected PersistedProperty createPersistedProperty(ManagedProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("Null managed property.");
        }
        PersistedProperty persisted = new PersistedProperty();
        persisted.setName(property.getName());
        return persisted;
    }

    protected boolean processProperty(ManagedProperty property, PersistedProperty persisted) {
        boolean trace = log.isTraceEnabled();
        return this.processProperty(property, persisted, trace);
    }

    protected boolean processProperty(ManagedProperty property, PersistedProperty persisted, boolean trace) {
        if (property == null) {
            throw new IllegalArgumentException("Null managed property.");
        }
        if (persisted == null) {
            throw new IllegalArgumentException("Null persisted property.");
        }
        boolean processed = false;
        if (this.isProcessProperty(property, trace)) {
            PersistedValue value;
            MetaValue metaValue = (MetaValue)property.getField("value", MetaValue.class);
            MetaType metaType = (MetaType)property.getField("metaType", MetaType.class);
            if (metaValue != null) {
                metaType = metaValue.getMetaType();
            }
            if ((value = this.createPersistedValue(metaValue, metaType, persisted.getValue())) != null) {
                persisted.setValue(value);
                if (trace) {
                    log.trace((Object)("value for property (" + property.getName() + "): " + value));
                }
                processed = true;
            }
        }
        return processed;
    }

    private PersistedValue createPersistedValue(MetaValue metaValue, MetaType metaType, PersistedValue persisted) {
        return this.getValuePersistence().createPersistedValue(metaValue, metaType, persisted);
    }

    protected boolean isProcessProperty(ManagedProperty property, boolean trace) {
        boolean process = false;
        if (property == null) {
            return process;
        }
        if (!property.hasViewUse(ViewUse.CONFIGURATION)) {
            if (trace) {
                log.trace((Object)("Skip non configuration property: " + property.getName()));
            }
            return process;
        }
        if (property.isReadOnly()) {
            if (trace) {
                log.trace((Object)("Skip readOnly property: " + property.getName()));
            }
            return process;
        }
        PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (propertyInfo != null && !propertyInfo.isReadable()) {
            if (trace) {
                log.trace((Object)("Skip non readable property: " + property.getName()));
            }
            return process;
        }
        return true;
    }

    protected static Map<String, PersistedProperty> getPersistedProperties(PersistedManagedObject persisted) {
        if (persisted == null) {
            throw new IllegalArgumentException("Null persisted managed object.");
        }
        HashMap<String, PersistedProperty> properties = new HashMap<String, PersistedProperty>();
        List<PersistedProperty> list = persisted.getProperties();
        if (list == null) {
            list = new ArrayList<PersistedProperty>();
            persisted.setProperties(list);
        }
        if (!list.isEmpty()) {
            for (PersistedProperty p : list) {
                properties.put(p.getName(), p);
            }
        }
        return properties;
    }
}

