/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.WeakHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.InstanceFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.plugins.values.ListInstanceFactory;
import org.jboss.metatype.plugins.values.SetInstanceFactory;
import org.jboss.metatype.plugins.values.SortedSetInstanceFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.system.server.profileservice.persistence.ManagedObjectOverride;
import org.jboss.system.server.profileservice.persistence.xml.ModificationInfo;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedGenericOverrideHandler
extends ManagedObjectOverride {
    private Map<Class<?>, InstanceFactory<?>> instanceFactoryMap = new WeakHashMap();
    private Stack<MergingProperties> properties = new Stack();
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });

    public ManagedGenericOverrideHandler() {
        this.setInstanceFactory((Class)List.class, (InstanceFactory)ListInstanceFactory.INSTANCE);
        this.setInstanceFactory((Class)Set.class, (InstanceFactory)SetInstanceFactory.INSTANCE);
        this.setInstanceFactory((Class)SortedSet.class, (InstanceFactory)SortedSetInstanceFactory.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setInstanceFactory(Class<T> clazz, InstanceFactory<T> factory) {
        Map<Class<?>, InstanceFactory<?>> map = this.instanceFactoryMap;
        synchronized (map) {
            if (factory == null) {
                this.instanceFactoryMap.remove(clazz);
            } else {
                this.instanceFactoryMap.put(clazz, factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processProperty(ManagedProperty property, PersistedProperty propertyElement, Object attachment, boolean trace) throws Throwable {
        if (property == null) {
            throw new IllegalStateException("Null property");
        }
        PropertyInfo info = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (!info.isReadable()) {
            log.trace((Object)("Skipping not readable property " + info));
            return;
        }
        MergingProperties item = new MergingProperties(attachment, info, propertyElement);
        this.properties.push(item);
        try {
            super.processProperty(property, propertyElement, attachment, trace);
        }
        finally {
            this.properties.pop();
        }
    }

    @Override
    protected void setValue(ManagedProperty property, MetaValue value, Object attachment) throws Throwable {
        if (value == null) {
            return;
        }
        if (value.getMetaType().isGeneric() && value.getMetaType().equals(GENERIC_PERSISTED_VALUE_TYPE)) {
            PersistedGenericValue moElement = (PersistedGenericValue)((GenericValue)value).getValue();
            if (moElement.getManagedObject() == null) {
                return;
            }
            if (moElement.getManagedObject().getClassName() == null && moElement.getManagedObject().getTemplateName() == null) {
                return;
            }
            ManagedObject mo = this.createManagedObject(moElement.getManagedObject());
            value = new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)mo);
        }
        super.setValue(property, value, attachment);
    }

    @Override
    protected CollectionValue mergeCollection(CollectionValue original, CollectionValue override, boolean trace) throws Throwable {
        CollectionMetaType metaType = original.getMetaType();
        if (metaType.getElementType().isGeneric()) {
            MergingProperties item = this.properties.peek();
            PropertyInfo propertyInfo = item.getPropertyInfo();
            Object attachment = item.getAttachment();
            if (!propertyInfo.isWritable()) {
                log.debug((Object)("Ignoring not writable property: " + propertyInfo));
                return null;
            }
            Collection c = (Collection)propertyInfo.get(attachment);
            if (c == null || c.isEmpty()) {
                return null;
            }
            if (c.size() < override.getSize()) {
                throw new IllegalStateException("c.size() < override.getSize()");
            }
            HashSet<String> removedNames = new HashSet<String>();
            for (MetaValue mv : override) {
                GenericValue overrideGeneric = (GenericValue)mv;
                PersistedGenericValue overrideGenericValue = (PersistedGenericValue)overrideGeneric.getValue();
                PersistedManagedObject pmo = overrideGenericValue.getManagedObject();
                if (pmo.getModificationInfo() != ModificationInfo.REMOVED) continue;
                String name = overrideGenericValue.getManagedObject().getName();
                if (name == null) {
                    name = overrideGenericValue.getManagedObject().getOriginalName();
                }
                if (name == null) continue;
                removedNames.add(name);
            }
            Iterator rawIterator = c.iterator();
            Iterator originalIterator = original.iterator();
            Iterator overrideIterator = override.iterator();
            BeanInfo beanInfo = configuration.getBeanInfo(propertyInfo.getType());
            Collection newCollection = (Collection)this.createNewInstance(beanInfo);
            while (rawIterator.hasNext()) {
                ManagedObject originalMO;
                String name;
                Object o = rawIterator.next();
                GenericValue originalGeneric = (GenericValue)originalIterator.next();
                GenericValue overrideGeneric = (GenericValue)overrideIterator.next();
                PersistedGenericValue overrideGenericValue = (PersistedGenericValue)overrideGeneric.getValue();
                if (originalGeneric.getValue() == null) {
                    newCollection.add(o);
                    continue;
                }
                Serializable og = originalGeneric.getValue();
                if (og instanceof ManagedObject && removedNames.contains(name = (originalMO = (ManagedObject)og).getName())) continue;
                this.processGenericValue(originalGeneric, overrideGenericValue, trace);
                newCollection.add(o);
            }
            propertyInfo.set(attachment, (Object)newCollection);
            return null;
        }
        return super.mergeCollection(original, override, trace);
    }

    protected Object createNewInstance(BeanInfo beanInfo) throws Throwable {
        ClassInfo classInfo = beanInfo.getClassInfo();
        if (classInfo.isInterface()) {
            InstanceFactory<?> instanceFactory = this.instanceFactoryMap.get(classInfo.getType());
            if (instanceFactory == null) {
                throw new IllegalArgumentException("Cannot instantiate interface BeanInfo, missing InstanceFactory: " + classInfo);
            }
            return instanceFactory.instantiate(beanInfo);
        }
        return beanInfo.newInstance();
    }

    public static class MergingProperties {
        private Object attachment;
        private PropertyInfo propertyInfo;
        private PersistedProperty propertyElement;

        public MergingProperties(Object attachment, PropertyInfo info, PersistedProperty propertyElement) {
            this.attachment = attachment;
            this.propertyInfo = info;
            this.propertyElement = propertyElement;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public PropertyInfo getPropertyInfo() {
            return this.propertyInfo;
        }

        public PersistedProperty getPropertyElement() {
            return this.propertyElement;
        }
    }
}

