/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.system.server.profileservice.persistence.ManagedGenericOverrideHandler;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;

public class ProfileServicePersistenceDeployer
extends AbstractRealDeployer {
    public static final String PERSISTED_ATTACHMENT_PREFIX = "PERISTED";
    private ManagedGenericOverrideHandler overrideHandler = new ManagedGenericOverrideHandler();
    private ManagedObjectFactory factory = ManagedObjectFactory.getInstance();
    private static final Logger log = Logger.getLogger(ProfileServicePersistenceDeployer.class);

    public ProfileServicePersistenceDeployer() {
        this.setAllInputs(true);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    public ManagedObjectFactory getManagedObjectFactory() {
        return this.factory;
    }

    public void setManagedObjectFactory(ManagedObjectFactory factory) {
        this.factory = factory;
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        Set attachments = unit.getTransientManagedObjects().getAttachments().keySet();
        for (String attachment : attachments) {
            PersistedManagedObject persistedManagedObject = (PersistedManagedObject)unit.getAttachment(PERSISTED_ATTACHMENT_PREFIX + attachment);
            if (persistedManagedObject == null) continue;
            Object instance = unit.getTransientManagedObjects().getAttachment(attachment);
            try {
                MetaData metaData = unit.getMetaData();
                ManagedObject original = this.factory.initManagedObject(instance, metaData);
                this.overrideHandler.updateManagedObject(original, persistedManagedObject, instance);
                unit.addAttachment(attachment, original.getAttachment());
            }
            catch (Throwable e) {
                log.debug((Object)"Failed to update the persisted attachment information", e);
            }
        }
    }
}

