/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProfileDeployment
implements ProfileDeployment {
    private String name;
    private VirtualFile root;
    private Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private transient Map<String, Object> transientAttachments = new ConcurrentHashMap<String, Object>();
    private static final long serialVersionUID = -2208890215429044674L;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractProfileDeployment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        this.name = name;
    }

    public AbstractProfileDeployment(VirtualFile root) {
        this(AbstractProfileDeployment.safeVirtualFileName(root));
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public Map<String, Object> getAttachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public Object getAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.attachments.get(name);
    }

    public <T> T getAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("null expected type");
        }
        Object attachment = this.getAttachment(name);
        if (attachment == null) {
            return null;
        }
        if (!expectedType.isInstance(attachment)) {
            throw new IllegalStateException("attachment " + name + " with value " + attachment + " is not of the expected type " + expectedType);
        }
        return expectedType.cast(attachment);
    }

    public Object addAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment.");
        }
        return this.attachments.put(name, attachment);
    }

    public Object removeAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.attachments.remove(name);
    }

    public Object getTransientAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.transientAttachments.get(name);
    }

    public <T> T getTransientAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("null expected type");
        }
        Object attachment = this.getTransientAttachment(name);
        if (attachment == null) {
            return null;
        }
        if (!expectedType.isInstance(attachment)) {
            throw new IllegalStateException("attachment " + name + " with value " + attachment + " is not of the expected type " + expectedType);
        }
        return expectedType.cast(attachment);
    }

    public Object addTransientAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment.");
        }
        return this.transientAttachments.put(name, attachment);
    }

    public Object removeTransientAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.transientAttachments.remove(name);
    }

    public String toString() {
        return "AbstractProfileDeployment(" + this.root != null ? this.root.getName() : this.name + ")";
    }
}

