/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.jmx;

import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import java.util.HashMap;
import java.util.Hashtable;

/**
 * RMIAdapter replacement using JMXConnector
 * @author Scott Marlow smarlow@redhat.com
 *
 */
public class JMXAdapter implements ObjectFactory {

   public JMXAdapter() {

   }
   
   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
      if ( obj != null && obj instanceof Reference) {
         Reference ref = (Reference)obj;
         // The JMXServiceURL points to the jmx server
         RefAddr urlRef = ref.get("JMXServiceURL");
         String  url = (String)urlRef.getContent();
         JMXServiceURL jmxserviceURL = new JMXServiceURL(url);
         // TODO:  security...
         HashMap env = new HashMap();
         javax.management.remote.JMXConnector jmxc = JMXConnectorFactory.connect(jmxserviceURL, env);
         return jmxc.getMBeanServerConnection();
      }
      return null;
   }
}
