/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.repository.AbstractProfileDeployment;
import org.jboss.system.server.profileservice.repository.AutoUnmounter;
import org.jboss.vfs.VirtualFile;

public class DefaultProfileDeploymentFactory
extends AutoUnmounter {
    private static final DefaultProfileDeploymentFactory INSTANCE = new DefaultProfileDeploymentFactory();

    public static String createDeploymentName(VirtualFile original) throws URISyntaxException {
        return DefaultProfileDeploymentFactory.createDeploymentName(original.toURI());
    }

    public static String createDeploymentName(URI uri) {
        String name = uri.toString();
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected DefaultProfileDeploymentFactory() {
    }

    public static DefaultProfileDeploymentFactory getInstance() {
        return INSTANCE;
    }

    public ProfileDeployment createProfileDeployment(String name) {
        return new AbstractProfileDeployment(name);
    }

    @Deprecated
    public ProfileDeployment createProfileDeployment(VirtualFile vf) throws URISyntaxException {
        String name = DefaultProfileDeploymentFactory.createDeploymentName(vf);
        return new AbstractProfileDeployment(name, vf);
    }

    public ProfileDeployment createProfileDeployment(String profileName, String name, VirtualFile original) throws IOException {
        VirtualFile copy = this.backup(profileName, name, original);
        return new AbstractProfileDeployment(name, copy);
    }

    public void cleanup(String deploymentName) throws IOException {
        super.cleanup(deploymentName);
    }
}

