/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profile.repository.AbstractImmutableProfile;
import org.jboss.system.server.profile.repository.metadata.FilteredProfileMetaData;
import org.jboss.system.server.profileservice.repository.AbstractProfileFactory;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredProfileFactory
extends AbstractProfileFactory
implements ProfileFactory {
    public static final Collection<String> types = Arrays.asList(FilteredProfileMetaData.class.getName());

    public String[] getTypes() {
        return types.toArray(new String[types.size()]);
    }

    @Override
    public Profile createProfile(ProfileKey key, ProfileMetaData metaData, List<ProfileKey> subProfiles) throws URISyntaxException {
        if (metaData.getDeployments() != null && !metaData.getDeployments().isEmpty()) {
            return new FilteredProfile(key, this.createURIs(metaData), subProfiles, this.getDeploymentNames(metaData));
        }
        return new AbstractImmutableProfile(key, this.createURIs(metaData), subProfiles);
    }

    protected URI[] createURIs(ProfileMetaData metaData) throws URISyntaxException {
        ProfileSourceMetaData profileSource = metaData.getSource();
        if (profileSource == null) {
            throw new IllegalArgumentException("Null profile source.");
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String source : profileSource.getSources()) {
            URI uri = new URI(source);
            uris.add(uri);
        }
        return uris.toArray(new URI[uris.size()]);
    }

    protected List<String> getDeploymentNames(ProfileMetaData metaData) {
        ArrayList<String> deploymentNames = new ArrayList<String>();
        if (metaData.getDeployments() != null && !metaData.getDeployments().isEmpty()) {
            for (ProfileDeploymentMetaData deployment : metaData.getDeployments()) {
                deploymentNames.add(deployment.getName());
            }
        }
        return deploymentNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilteredProfile
    extends AbstractImmutableProfile {
        private List<String> deploymentNames;

        public FilteredProfile(ProfileKey key, URI[] uris, List<String> deploymentNames) {
            this(key, uris, null, deploymentNames);
        }

        public FilteredProfile(ProfileKey key, URI[] uris, List<ProfileKey> subprofiles, List<String> deploymentNames) {
            super(key, uris, subprofiles);
            if (deploymentNames == null) {
                throw new IllegalArgumentException("Null profile deployments.");
            }
            this.deploymentNames = deploymentNames;
        }

        @Override
        public void create() throws Exception {
            for (String deploymentName : this.deploymentNames) {
                VirtualFile vf = this.resolveDeploymentName(deploymentName);
                ProfileDeployment deployment = this.createDeployment(vf);
                this.addDeployment(deployment.getName(), deployment);
            }
            this.updateLastModfied();
        }

        protected VirtualFile resolveDeploymentName(String deploymentName) throws Exception {
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
            for (URI uri : this.getRepositoryURIs()) {
                VirtualFile repo = this.getCachedVirtualFile(uri);
                VirtualFile vf = repo.getChild(deploymentName);
                if (!vf.exists()) continue;
                list.add(vf);
            }
            if (list.size() == 0) {
                throw new FileNotFoundException("Unable to find name: " + deploymentName);
            }
            if (list.size() > 1) {
                throw new FileNotFoundException("Multiple matching names: " + deploymentName + " available " + list);
            }
            return (VirtualFile)list.get(0);
        }
    }
}

