/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.BasicDeploymentRepository;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotDeploymentRepository
extends BasicDeploymentRepository {
    private StructureModificationChecker checker;

    public HotDeploymentRepository(ProfileKey key, URI[] uris) {
        super(key, uris);
    }

    protected StructureModificationChecker getChecker() {
        if (this.checker == null) {
            throw new IllegalArgumentException("Checker must be set");
        }
        return this.checker;
    }

    public void setChecker(StructureModificationChecker checker) {
        this.checker = checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        boolean trace = this.log.isTraceEnabled();
        Collection<ProfileDeployment> apps = this.getDeployments();
        HashMap<String, ModificationInfo> modifications = new HashMap<String, ModificationInfo>();
        if (trace) {
            this.log.trace((Object)"Checking applications for modifications");
        }
        if (trace) {
            this.log.trace((Object)"Aquiring content read lock");
        }
        this.lockRead();
        try {
            if (apps != null) {
                Iterator<ProfileDeployment> iter = apps.iterator();
                while (iter.hasNext()) {
                    ModificationInfo info;
                    long rootLastModified;
                    ProfileDeployment ctx = iter.next();
                    VirtualFile root = ctx.getRoot();
                    String pathName = ctx.getName();
                    if (this.hasDeploymentContentFlags(pathName, 5)) {
                        if (!trace) continue;
                        this.log.trace((Object)("Ignoring locked application: " + root));
                        continue;
                    }
                    if (!root.exists()) {
                        rootLastModified = root.getLastModified();
                        info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.REMOVED);
                        modifications.put(pathName, info);
                        iter.remove();
                        this.cleanUpRoot(root);
                        this.cleanupDeployment(pathName);
                        if (!trace) continue;
                        this.log.trace((Object)(pathName + " was removed"));
                        continue;
                    }
                    if (!this.hasDeploymentContentFlags(pathName, 8) && !this.getChecker().hasStructureBeenModified(pathName, root)) continue;
                    rootLastModified = root.getLastModified();
                    if (trace) {
                        this.log.trace((Object)(pathName + " was modified: " + rootLastModified));
                    }
                    info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.MODIFIED);
                    modifications.put(pathName, info);
                }
                this.checkForAdditions(modifications);
            }
        }
        finally {
            this.unlockRead();
            if (trace) {
                this.log.trace((Object)"Released content read lock");
            }
        }
        if (modifications.size() > 0) {
            this.updateLastModfied();
        }
        return modifications.values();
    }

    protected void checkForAdditions(Map<String, ModificationInfo> modified) throws Exception {
        for (URI applicationDir : this.getRepositoryURIs()) {
            VirtualFile deployDir = this.getCachedVirtualFile(applicationDir);
            ArrayList<VirtualFile> added = new ArrayList<VirtualFile>();
            this.addedDeployment(added, deployDir);
            this.applyAddedDeployments(applicationDir, modified, added);
        }
    }

    protected void applyAddedDeployments(URI applicationDir, Map<String, ModificationInfo> modified, List<VirtualFile> added) throws Exception {
        for (VirtualFile vf : added) {
            String pathName = HotDeploymentRepository.createDeploymentName(vf);
            if (modified.containsKey(pathName)) continue;
            ProfileDeployment ctx = this.createDeployment(vf);
            ModificationInfo info = new ModificationInfo(ctx, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
            modified.put(pathName, info);
            this.internalAddDeployment(ctx.getName(), ctx);
            this.getChecker().addStructureRoot(vf);
        }
    }

    @Override
    protected void cleanUpRoot(VirtualFile vf) {
        this.getChecker().removeStructureRoot(vf);
    }
}

