/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.profileservice.deployment.DeploymentBuilder;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.deployers.StructureMetaDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDFDeploymentBuilder
implements DeploymentBuilder<Deployment> {
    private static final VDFDeploymentBuilder instance = new VDFDeploymentBuilder();
    private static final VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private final List<DeploymentBuilder.DeploymentAttachmentsProcessor<Deployment>> attachmentProcessors = new ArrayList<DeploymentBuilder.DeploymentAttachmentsProcessor<Deployment>>();

    public static VDFDeploymentBuilder getInstance() {
        return instance;
    }

    protected VDFDeploymentBuilder() {
        this.attachmentProcessors.add(new StructureMetaDataBuilder());
    }

    public Deployment createDeployment(ProfileDeployment profileDeployment) {
        Object d = null;
        d = profileDeployment.getRoot() == null ? new AbstractDeployment(profileDeployment.getName()) : deploymentFactory.createVFSDeployment(profileDeployment.getName(), profileDeployment.getRoot());
        for (DeploymentBuilder.DeploymentAttachmentsProcessor<Deployment> processor : this.attachmentProcessors) {
            processor.processDeployment(profileDeployment, d);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttachmentsProcessor(DeploymentBuilder.DeploymentAttachmentsProcessor<Deployment> processor) {
        List<DeploymentBuilder.DeploymentAttachmentsProcessor<Deployment>> list = this.attachmentProcessors;
        synchronized (list) {
            this.attachmentProcessors.add(processor);
        }
    }
}

