/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.profileservice.deployment.AbstractProfileDeployment;
import org.jboss.profileservice.repository.ProfileDeploymentFactory;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.repository.AutoUnmounter;
import org.jboss.vfs.VirtualFile;

public class LegacyProfileDeploymentFactory
extends AutoUnmounter {
    private static final LegacyProfileDeploymentFactory INSTANCE = new LegacyProfileDeploymentFactory();
    private ProfileDeploymentFactory delegate = ProfileDeploymentFactory.getInstance();

    public static String createDeploymentName(VirtualFile original) throws URISyntaxException {
        return original.asFileURI().toString();
    }

    public static String createDeploymentName(URI uri) {
        String name = uri.toString();
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static LegacyProfileDeploymentFactory getInstance() {
        return INSTANCE;
    }

    protected LegacyProfileDeploymentFactory() {
    }

    public ProfileDeployment createProfileDeployment(String name) {
        return this.delegate.createDeployment(name);
    }

    @Deprecated
    public ProfileDeployment createProfileDeployment(VirtualFile vf) throws URISyntaxException {
        String name = LegacyProfileDeploymentFactory.createDeploymentName(vf);
        return new WorkaroundProfileDeployment(name, vf);
    }

    public ProfileDeployment createProfileDeployment(String profileName, String name, VirtualFile original) throws IOException {
        VirtualFile copy = this.backup(profileName, name, original);
        return new WorkaroundProfileDeployment(name, copy);
    }

    public void cleanup(String deploymentName) throws IOException {
        super.cleanup(deploymentName);
    }

    public class WorkaroundProfileDeployment
    extends AbstractProfileDeployment {
        protected WorkaroundProfileDeployment(String name, VirtualFile root) {
            super(name, ProfileDeploymentFactory.noopDeploymentMetaData);
            this.setRoot(root);
        }
    }
}

