/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationId<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -604832735573100571L;
    private static final long vm_base = System.currentTimeMillis();
    private static final AtomicInteger count = new AtomicInteger();
    private final T originator;
    private final long timestamp = vm_base;
    private final int index = count.incrementAndGet();

    public SynchronizationId(T originator) {
        if (originator == null) {
            throw new IllegalArgumentException("Null originator");
        }
        this.originator = originator;
    }

    public T getOriginator() {
        return this.originator;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SynchronizationId) {
            SynchronizationId other = (SynchronizationId)obj;
            return this.index == other.index && this.timestamp == other.timestamp && this.originator.equals(other.originator);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.index;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.originator.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[originator='" + this.originator + ",timestamp=" + this.timestamp + ",index=" + this.index + ']';
    }
}

