/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.file.AbstractFileWriteAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.ByteChunk;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationReadAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddContentStreamAction
extends AbstractFileWriteAction
implements SynchronizationReadAction<FileBasedSynchronizationActionContext> {
    private static final Logger log = Logger.getLogger(AddContentStreamAction.class);
    public static final int MAX_CHUNK_BUFFER_SIZE = 524288;
    private final InputStream stream;

    public AddContentStreamAction(InputStream stream, File targetFile, FileBasedSynchronizationActionContext context, ContentModification modification) {
        super(targetFile, context, modification);
        if (stream == null) {
            throw new IllegalArgumentException("Null stream");
        }
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteChunk getNextBytes() throws IOException {
        InputStream is = this.getInputStream();
        byte[] b = null;
        int read = -1;
        InputStream inputStream = is;
        synchronized (inputStream) {
            b = new byte[524288];
            read = is.read(b);
        }
        ByteChunk byteChunk = new ByteChunk(b, read);
        if (byteChunk.getByteCount() > -1) {
            this.writeBytes(byteChunk);
        }
        return byteChunk;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    private synchronized InputStream getInputStream() throws IOException {
        AbstractSynchronizationAction.State s = this.getState();
        if (s != AbstractSynchronizationAction.State.OPEN && s != AbstractSynchronizationAction.State.CANCELLED) {
            throw new IllegalStateException("Cannot read when state is " + (Object)((Object)s));
        }
        return this.stream;
    }
}

