/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.profileservice.spi.Profile;
import org.jboss.system.server.profileservice.repository.AbstractProfileAction;

public abstract class AbstractProfileLifeCycleAction
extends AbstractProfileAction {
    private static final Class<?>[] methodTypes = new Class[0];
    private static final Object[] args = new Object[0];

    protected abstract String getInstallMethod();

    protected abstract String getUninstallMethod();

    public void install(Profile profile) throws Exception {
        AbstractProfileLifeCycleAction.invoke(profile, this.getInstallMethod());
    }

    public void uninstall(Profile profile) {
        try {
            AbstractProfileLifeCycleAction.invoke(profile, this.getUninstallMethod());
        }
        catch (Exception e) {
            this.log.warn((Object)("Error invoking uninstall method '" + this.getUninstallMethod() + "' on profile: " + profile.getKey()));
        }
    }

    protected static void invoke(Profile profile, String method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = null;
        try {
            m = profile.getClass().getMethod(method, methodTypes);
        }
        catch (NoSuchMethodException ignore) {
            return;
        }
        AbstractProfileLifeCycleAction.invoke(profile, m);
    }

    private static void invoke(Profile profile, final Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            method.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
        method.invoke((Object)profile, args);
    }
}

