/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SyncFailedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.profileservice.spi.DeploymentOption;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.AbstractDeploymentRepository;
import org.jboss.system.server.profileservice.repository.DeploymentUtils;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDeploymentRepository
extends AbstractDeploymentRepository {
    private boolean failIfAlreadyExists = false;
    private URI uploadUri;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    public BasicDeploymentRepository(ProfileKey key, URI[] uris) {
        super(key, uris);
    }

    public boolean isFailIfAlreadyExists() {
        return this.failIfAlreadyExists;
    }

    public void setFailIfAlreadyExists(boolean failIfAlreadyExists) {
        this.failIfAlreadyExists = failIfAlreadyExists;
    }

    public URI getUploadUri() {
        if (this.uploadUri != null) {
            return this.uploadUri;
        }
        if (this.getRepositoryURIs() != null && this.getRepositoryURIs().length > 0) {
            return this.getRepositoryURIs()[0];
        }
        throw new IllegalArgumentException("No upload uri available.");
    }

    public void setUploadUri(URI uploadUri) {
        if (uploadUri == null) {
            this.uploadUri = null;
            return;
        }
        if (this.getRepositoryURIs() != null && this.getRepositoryURIs().length > 0 && Arrays.asList(this.getRepositoryURIs()).contains(uploadUri)) {
            this.uploadUri = uploadUri;
            return;
        }
        throw new IllegalArgumentException("Upload uri is not managed by this repository: " + uploadUri);
    }

    public void load() throws Exception {
        for (URI uri : this.getRepositoryURIs()) {
            VirtualFile root = this.getCachedVirtualFile(uri);
            this.loadApplications(root);
        }
        this.updateLastModfied();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeployment(String vfsPath, ProfileDeployment d) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Aquiring content write lock");
        }
        this.lockWrite();
        try {
            this.internalAddDeployment(vfsPath, d);
        }
        finally {
            this.unlockWrite();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Released content write lock");
            }
        }
    }

    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        return Collections.emptySet();
    }

    public String addDeploymentContent(String vfsPath, InputStream contentIS) throws IOException {
        return this.addDeploymentContent(vfsPath, contentIS, new DeploymentOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDeploymentContent(String vfsPath, InputStream contentIS, DeploymentOption ... options) throws IOException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"Aquiring content write lock");
        }
        this.lockWrite();
        String repositoryName = null;
        try {
            boolean failIfAlreadyExsists;
            File contentRoot = new File(this.getUploadUri());
            if (contentRoot == null) {
                throw new FileNotFoundException("Failed to obtain content dir for phase: " + vfsPath);
            }
            if (!contentRoot.isDirectory()) {
                throw new FileNotFoundException("The content root is not a directory." + contentRoot.getAbsolutePath());
            }
            File contentFile = new File(contentRoot, vfsPath);
            boolean exists = contentFile.exists();
            List<DeploymentOption> deploymentOptions = Arrays.asList(options);
            boolean bl = failIfAlreadyExsists = this.isFailIfAlreadyExists() || deploymentOptions.contains(DeploymentOption.FailIfExists);
            if (exists && failIfAlreadyExsists) {
                throw new SyncFailedException("Deployment content already exists: " + contentFile.getAbsolutePath());
            }
            if (deploymentOptions.contains(DeploymentOption.Explode)) {
                DeploymentUtils.unjar(contentIS, contentFile);
            } else {
                FileOutputStream fos = new FileOutputStream(contentFile);
                try {
                    int read;
                    byte[] tmp = new byte[4096];
                    while ((read = contentIS.read(tmp)) > 0) {
                        if (trace) {
                            this.log.trace((Object)("write, " + read));
                        }
                        fos.write(tmp, 0, read);
                    }
                    fos.flush();
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            VirtualFile contentVF = VFS.getRoot((URI)contentFile.toURI());
            try {
                repositoryName = this.addVirtualFileCache(contentVF);
                if (exists) {
                    this.cleanUpRoot(contentVF);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.setDeploymentContentFlags(repositoryName, 4);
        }
        finally {
            this.unlockWrite();
            if (trace) {
                this.log.trace((Object)"Released content write lock");
            }
        }
        return repositoryName;
    }

    @Override
    public ProfileDeployment removeDeployment(String vfsPath) throws Exception {
        return this.removeDeployment(vfsPath, true);
    }

    protected void internalAddDeployment(String vfsPath, ProfileDeployment deployment) throws Exception {
        super.addDeployment(vfsPath, deployment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProfileDeployment removeDeployment(String vfsPath, boolean deleteFile) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Aquiring content write lock");
        }
        this.lockWrite();
        try {
            ProfileDeployment deployment = this.getDeployment(vfsPath);
            VirtualFile root = deployment.getRoot();
            if (deleteFile && root != null) {
                if (!root.delete() && root.exists()) {
                    throw new IOException("Failed to delete: " + root);
                }
                this.cleanUpRoot(root);
            }
            ProfileDeployment profileDeployment = super.removeDeployment(deployment.getName());
            return profileDeployment;
        }
        finally {
            this.unlockWrite();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Released content write lock");
            }
        }
    }

    protected void cleanUpRoot(VirtualFile vf) {
    }

    public void remove() throws Exception {
    }

    protected void lockRead() {
        this.lock.readLock().lock();
    }

    protected void unlockRead() {
        this.lock.readLock().unlock();
    }

    protected void lockWrite() {
        this.lock.writeLock().lock();
    }

    protected void unlockWrite() {
        this.lock.writeLock().unlock();
    }
}

