/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASBasedServer;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.AbstractContentMetadataPersister;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBRepositoryContentMetadataPersister
extends AbstractContentMetadataPersister {
    private static final Logger log = Logger.getLogger(JAXBRepositoryContentMetadataPersister.class);
    private static final String METADATA_SUFFIX = "-repository-contents.xml";
    private static final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public JAXBRepositoryContentMetadataPersister(JBossASBasedServer<?, ?> server) throws Throwable {
        this(((JBossASBasedServerConfig)server.getConfiguration()).getServerDataLocation());
    }

    public JAXBRepositoryContentMetadataPersister(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public JAXBRepositoryContentMetadataPersister(URI uri) {
        this(new File(uri));
    }

    public JAXBRepositoryContentMetadataPersister(File dir) {
        super(dir);
    }

    @Override
    public File getMetadataPath(String storeName) {
        String vfsPath = storeName + METADATA_SUFFIX;
        return new File(this.getContentMetadataDir(), vfsPath);
    }

    @Override
    protected RepositoryContentMetadata loadMetadata(File metadataStore) throws Exception {
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        return (RepositoryContentMetadata)unmarshaller.unmarshal(metadataStore.toURL().openStream(), (SchemaBindingResolver)resolver);
    }

    @Override
    protected void saveMetadata(File metadataStore, RepositoryContentMetadata metadata) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saveMetadata, metadataStore=" + metadataStore + ", metadata=" + metadata));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{metadata.getClass()});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)metadata, metadataStore);
    }

    static {
        resolver.addClassBindingForLocation("repository-content", RepositoryContentMetadata.class);
    }
}

