/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.profileservice.deployment.DeploymentBuilder;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.virtual.assembly.VirtualDeploymentAssemblyContext;
import org.jboss.profileservice.virtual.assembly.BasicVirtualAssemblyContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMetaDataBuilder
implements DeploymentBuilder.DeploymentAttachmentsProcessor<Deployment> {
    private static final DeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();

    public void processDeployment(ProfileDeployment deployment, Deployment target) {
        VirtualDeploymentAssemblyContext ctx = (VirtualDeploymentAssemblyContext)deployment.getTransientAttachments().getAttachment(VirtualDeploymentAssemblyContext.class.getName(), VirtualDeploymentAssemblyContext.class);
        if (ctx != null) {
            this.createStructureMetaData(target, "", ctx);
        }
    }

    protected ContextInfo createStructureMetaData(Deployment deployment, String path, VirtualDeploymentAssemblyContext ctx) {
        if (ctx instanceof BasicVirtualAssemblyContext) {
            return this.createStructureMetaData(deployment, path, (BasicVirtualAssemblyContext)ctx);
        }
        return null;
    }

    protected ContextInfo createStructureMetaData(Deployment deployment, String path, BasicVirtualAssemblyContext ctx) {
        List metaDataLocations = ctx.getMetaDataLocations();
        List<ClassPathEntry> classPathEntries = this.getClassPathEntries(ctx);
        ContextInfo info = deploymentFactory.addContext((PredeterminedManagedObjectAttachments)deployment, path, metaDataLocations, classPathEntries);
        if (ctx.getChildren() != null && !ctx.getChildren().isEmpty()) {
            for (VirtualDeploymentAssemblyContext child : ctx.getChildren()) {
                String childPath = child.getRoot().getName();
                this.createStructureMetaData(deployment, childPath, child);
            }
        }
        return info;
    }

    protected List<ClassPathEntry> getClassPathEntries(BasicVirtualAssemblyContext ctx) {
        ArrayList<ClassPathEntry> entries = new ArrayList<ClassPathEntry>();
        if (ctx.getClassPathLocations() != null && !ctx.getClassPathLocations().isEmpty()) {
            for (String s : ctx.getClassPathLocations()) {
                entries.add(DeploymentFactory.createClassPathEntry((String)s));
            }
        }
        entries.add(DeploymentFactory.createClassPathEntry((String)""));
        return entries;
    }
}

