/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.il.http.HTTPClientILStorageQueue;
import org.jboss.mq.il.http.HTTPILRequest;
import org.jboss.mq.il.http.HTTPILResponse;
import org.jboss.mq.server.JMSServerInvoker;
import org.jboss.mx.util.MBeanServerLocator;

public class HTTPServerILServlet
extends HttpServlet {
    private static final String RESPONSE_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.mq.il.http.HTTPILResponse";
    private static Logger log = Logger.getLogger(HTTPServerILServlet.class);
    private MBeanServer server;
    private JMSServerInvoker invoker;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (log.isTraceEnabled()) {
            log.trace((Object)("init(ServletConfig " + config.toString() + ")"));
        }
        this.server = MBeanServerLocator.locateJBoss();
        if (this.server == null) {
            throw new ServletException("Failed to locate the MBeanServer");
        }
        String invokerName = config.getInitParameter("Invoker");
        if (invokerName == null) {
            throw new ServletException("Invoker must be specified as servlet init parameter");
        }
        log.debug((Object)("Invoker set to '" + invokerName + ".'"));
        try {
            this.invoker = (JMSServerInvoker)this.server.getAttribute(new ObjectName(invokerName), "Invoker");
        }
        catch (Exception exception) {
            throw new ServletException("Failed to locate the JBossMQ invoker.");
        }
    }

    public void destroy() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"destroy()");
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("processRequest(HttpServletRequest " + request.toString() + ", HttpServletResponse " + response.toString() + ")"));
        }
        response.setContentType(RESPONSE_CONTENT_TYPE);
        ObjectOutputStream outputStream = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            ObjectInputStream inputStream = new ObjectInputStream((InputStream)request.getInputStream());
            HTTPILRequest httpIlRequest = (HTTPILRequest)inputStream.readObject();
            String methodName = httpIlRequest.getMethodName();
            if (methodName.equals("clientListening")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("clientListening(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                String clientIlId = (String)httpIlRequest.getArguments()[0];
                long timeout = (Long)httpIlRequest.getArguments()[1];
                log.debug((Object)("Listening on behalf of a ClientIL #" + clientIlId + " for " + String.valueOf(timeout) + " milliseconds."));
                HTTPILRequest[] responseRequest = HTTPClientILStorageQueue.getInstance().get(clientIlId, timeout);
                log.debug((Object)("The following lines reflect the HTTPILRequest object to be packaged and returned to ClientIL #" + clientIlId + " as an HTTPILResponse."));
                for (int i = 0; i < responseRequest.length; ++i) {
                    log.debug((Object)("Response for ClientIL #" + clientIlId + " contains '" + responseRequest[i].toString() + ".'"));
                }
                outputStream.writeObject(new HTTPILResponse((Object)responseRequest));
            } else if (methodName.equals("getClientILIdentifer")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("getClientILIdentifer(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                String id = HTTPClientILStorageQueue.getInstance().getID();
                log.debug((Object)("Provided ClientIL Id #" + id + "."));
                outputStream.writeObject(new HTTPILResponse((Object)id));
            } else if (methodName.equals("stopClientListening")) {
                String clientIlId;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("stopClientListening(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                if ((clientIlId = (String)httpIlRequest.getArguments()[0]) != null) {
                    HTTPClientILStorageQueue.getInstance().purgeEntry(clientIlId);
                }
                outputStream.writeObject(new HTTPILResponse((Object)"Storage queue was purged."));
            } else if (methodName.equals("ping")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ping(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                ConnectionToken connectionToken = (ConnectionToken)httpIlRequest.getArguments()[0];
                long clientTime = (Long)httpIlRequest.getArguments()[1];
                this.invoker.ping(connectionToken, clientTime);
                outputStream.writeObject(new HTTPILResponse());
            } else if (methodName.equals("receive")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("receive(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                ConnectionToken connectionToken = (ConnectionToken)httpIlRequest.getArguments()[0];
                int subscriberId = (Integer)httpIlRequest.getArguments()[1];
                long wait = (Long)httpIlRequest.getArguments()[2];
                SpyMessage message = this.invoker.receive(connectionToken, subscriberId, wait);
                outputStream.writeObject(new HTTPILResponse((Object)message));
                if (message != null && log.isTraceEnabled()) {
                    log.debug((Object)("Returned an instance of '" + message.getClass().toString() + "' with value of '" + message.toString() + "'"));
                }
            } else if (methodName.equals("setEnabled")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("setEnabled(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                ConnectionToken connectionToken = (ConnectionToken)httpIlRequest.getArguments()[0];
                boolean enabled = (Boolean)httpIlRequest.getArguments()[1];
                this.invoker.setEnabled(connectionToken, enabled);
                outputStream.writeObject(new HTTPILResponse());
            } else if (methodName.equals("unsubscribe")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("unsubscribe(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                ConnectionToken connectionToken = (ConnectionToken)httpIlRequest.getArguments()[0];
                int subscriberId = (Integer)httpIlRequest.getArguments()[1];
                this.invoker.unsubscribe(connectionToken, subscriberId);
                outputStream.writeObject(new HTTPILResponse());
            } else if (methodName.equals("recover")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("recover(HTTPILRequest " + httpIlRequest.toString() + ")"));
                }
                ConnectionToken connectionToken = (ConnectionToken)httpIlRequest.getArguments()[0];
                int flags = (Integer)httpIlRequest.getArguments()[1];
                Xid[] xids = this.invoker.recover(connectionToken, flags);
                outputStream.writeObject(new HTTPILResponse((Object)xids));
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("HTTPILRequest recieved: " + httpIlRequest.toString()));
                }
                Method method = this.invoker.getClass().getMethod(methodName, httpIlRequest.getArgumentTypes());
                Object returnValue = method.invoke((Object)this.invoker, httpIlRequest.getArguments());
                if (log.isTraceEnabled()) {
                    log.debug((Object)("Invoked method '" + methodName + ".'"));
                }
                outputStream.writeObject(new HTTPILResponse(returnValue));
                if (returnValue != null && log.isTraceEnabled()) {
                    log.debug((Object)("Returned an instance of '" + returnValue.getClass().toString() + "' with value of '" + returnValue.toString() + "'"));
                }
            }
        }
        catch (InvocationTargetException invocatonTargetException) {
            Throwable targetException = invocatonTargetException.getTargetException();
            if (log.isDebugEnabled()) {
                log.debug((Object)("The underlying invoker (i.e. The JMS Server itself) threw in exception of type '" + targetException.getClass().getName() + "' and a message of '" + targetException.getMessage() + ".'  This exception is being propogated to the client as a  HTTPILResponse."));
            }
            outputStream.writeObject(new HTTPILResponse((Object)targetException));
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Threw an exception of type '" + exception.getClass().getName() + "' with a message of '" + exception.getMessage() + ".'  This exception is being propogated to the client as a HTTPILResponse."));
            }
            outputStream.writeObject(new HTTPILResponse((Object)exception));
        }
        outputStream.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("doGet(HttpServletRequest " + request.toString() + ", HttpServletResponse " + response.toString() + ")"));
        }
        response.getWriter().print("<html><head><title>JBossMQ HTTP-IL Servlet</title><head><body><h1>This is the JBossMQ HTTP-IL</h1></body></html>");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"doPost() defers to processRequest, see the parameters in its trace.");
        }
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Provides an HTTP/S interface to JBossMQ";
    }
}

