/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment;

import java.util.Arrays;
import java.util.Collection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.system.ServiceController;
import org.jboss.system.microcontainer.LifecycleDependencyItem;
import org.jboss.system.microcontainer.ServiceControllerContext;
import org.jboss.varia.deployment.BeanShellScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyBeanShellScriptDeployer
extends AbstractSimpleRealDeployer<BeanShellScript> {
    public static final String BASE_SCRIPT_OBJECT_NAME = "jboss.scripts:type=BeanShell";
    private ServiceController serviceController;
    private ControllerMode mode = ControllerMode.AUTOMATIC;

    public LegacyBeanShellScriptDeployer(ServiceController serviceController) {
        super(BeanShellScript.class);
        if (serviceController == null) {
            throw new IllegalArgumentException("Null service controller.");
        }
        this.serviceController = serviceController;
    }

    protected ObjectName getBshScriptName(BeanShellScript script, DeploymentUnit deploymentUnit) throws MalformedObjectNameException {
        ObjectName bshScriptName = script.getPreferedObjectName();
        if (bshScriptName == null) {
            bshScriptName = ObjectNameConverter.convert((String)("jboss.scripts:type=BeanShell,url=" + deploymentUnit.getSimpleName()));
        }
        return bshScriptName;
    }

    public void deploy(DeploymentUnit deploymentUnit, BeanShellScript script) throws DeploymentException {
        try {
            KernelController controller = this.serviceController.getKernel().getController();
            ObjectName bshScriptName = this.getBshScriptName(script, deploymentUnit);
            ServiceControllerContext context = new ServiceControllerContext(this.serviceController, bshScriptName, (Object)script);
            context.setMode(this.mode);
            ObjectName[] depends = script.getDependsServices();
            if (depends != null) {
                this.addDependencies(context, Arrays.asList(depends));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Installing bean shell script: " + bshScriptName));
            }
            controller.install((ControllerContext)context);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Unable to deploy bean shell script.", (Throwable)t);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit, BeanShellScript script) {
        try {
            ObjectName bshScriptName = this.getBshScriptName(script, deploymentUnit);
            KernelController controller = this.serviceController.getKernel().getController();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Uninstalling bean shell script: " + bshScriptName));
            }
            controller.uninstall((Object)bshScriptName.getCanonicalName());
        }
        catch (Throwable t) {
            this.log.error((Object)("Exception while undeploying bean shell script: " + t));
        }
    }

    private void addDependencies(ServiceControllerContext context, Collection<ObjectName> depends) {
        DependencyInfo info = context.getDependencyInfo();
        for (ObjectName other : depends) {
            info.addIDependOn((DependencyItem)new LifecycleDependencyItem(context.getName(), (Object)other.getCanonicalName(), ControllerState.CREATE));
            info.addIDependOn((DependencyItem)new LifecycleDependencyItem(context.getName(), (Object)other.getCanonicalName(), ControllerState.START));
        }
    }

    public void setMode(String mode) {
        this.mode = new ControllerMode(mode);
    }
}

