/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.jmx.adaptor.control.OpResultInfo;
import org.jboss.jmx.adaptor.control.Server;
import org.jboss.jmx.adaptor.model.MBeanData;
import org.jboss.logging.Logger;

public class HtmlAdaptorServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(HtmlAdaptorServlet.class);
    private static final String ACTION_PARAM = "action";
    private static final String FILTER_PARAM = "filter";
    private static final String DISPLAY_MBEANS_ACTION = "displayMBeans";
    private static final String INSPECT_MBEAN_ACTION = "inspectMBean";
    private static final String UPDATE_ATTRIBUTES_ACTION = "updateAttributes";
    private static final String INVOKE_OP_ACTION = "invokeOp";
    private static final String INVOKE_OP_BY_NAME_ACTION = "invokeOpByName";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter(ACTION_PARAM);
        if (action == null) {
            action = DISPLAY_MBEANS_ACTION;
        }
        if (action.equals(DISPLAY_MBEANS_ACTION)) {
            this.displayMBeans(request, response);
        } else if (action.equals(INSPECT_MBEAN_ACTION)) {
            this.inspectMBean(request, response);
        } else if (action.equals(UPDATE_ATTRIBUTES_ACTION)) {
            this.updateAttributes(request, response);
        } else if (action.equals(INVOKE_OP_ACTION)) {
            this.invokeOp(request, response);
        } else if (action.equals(INVOKE_OP_BY_NAME_ACTION)) {
            this.invokeOpByName(request, response);
        }
    }

    private void displayMBeans(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Iterator mbeans;
        HttpSession session = request.getSession(false);
        String filter = request.getParameter(FILTER_PARAM);
        if (filter == null && session != null) {
            filter = (String)session.getAttribute(FILTER_PARAM);
        }
        if (filter != null && filter.length() > 0) {
            if (filter.charAt(0) == '\"') {
                filter = filter.substring(1);
            }
            if (filter.charAt(filter.length() - 1) == '\"') {
                filter = filter.substring(0, filter.length() - 2);
            }
            String domain = "*";
            String props = "*,*";
            int separator = filter.indexOf(58);
            int assignment = filter.indexOf(61);
            if (separator == -1 && assignment != -1) {
                props = filter.trim();
            } else if (separator == -1 && assignment == -1) {
                domain = filter.trim();
            } else {
                domain = filter.substring(0, separator).trim();
                props = filter.substring(separator + 1).trim();
            }
            if (domain.equals("")) {
                domain = "*";
            }
            if (props.equals("")) {
                props = "*,*";
            }
            if (props.endsWith(",")) {
                props = props + "*";
            }
            if (!props.endsWith(",*")) {
                props = props + ",*";
            }
            if (props.equals("*,*")) {
                props = "*";
            }
            if ((filter = domain + ":" + props).equals("*:*")) {
                filter = "";
            }
        } else {
            filter = "";
        }
        request.setAttribute(FILTER_PARAM, (Object)filter);
        if (session != null) {
            session.setAttribute(FILTER_PARAM, (Object)filter);
        }
        try {
            mbeans = Server.getDomainData(filter);
        }
        catch (JMException e) {
            request.setAttribute("filterError", (Object)e.getMessage());
            try {
                mbeans = Server.getDomainData("");
            }
            catch (JMException e1) {
                throw new ServletException("Failed to get MBeans", (Throwable)e);
            }
        }
        request.setAttribute("mbeans", (Object)mbeans);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/displayMBeans.jsp");
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void inspectMBean(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.trace((Object)("inspectMBean, name=" + name));
        try {
            MBeanData data = Server.getMBeanData(name);
            request.setAttribute("mbeanData", (Object)data);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/inspectMBean.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (JMException e) {
            throw new ServletException("Failed to get MBean data", (Throwable)e);
        }
    }

    private void updateAttributes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.trace((Object)("updateAttributes, name=" + name));
        Enumeration paramNames = request.getParameterNames();
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (paramNames.hasMoreElements()) {
            String param = (String)paramNames.nextElement();
            if (param.equals("name") || param.equals(ACTION_PARAM)) continue;
            String value = request.getParameter(param);
            log.trace((Object)("name=" + param + ", value='" + value + "'"));
            if (value == null || value.length() == 0) continue;
            attributes.put(param, value);
        }
        try {
            AttributeList newAttributes = Server.setAttributes(name, attributes);
            MBeanData data = Server.getMBeanData(name);
            request.setAttribute("mbeanData", (Object)data);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/inspectMBean.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (JMException e) {
            throw new ServletException("Failed to update attributes", (Throwable)e);
        }
    }

    private void invokeOp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.trace((Object)("invokeOp, name=" + name));
        String[] args = this.getArgs(request);
        String methodIndex = request.getParameter("methodIndex");
        if (methodIndex == null || methodIndex.length() == 0) {
            throw new ServletException("No methodIndex given in invokeOp form");
        }
        int index = Integer.parseInt(methodIndex);
        try {
            OpResultInfo opResult = Server.invokeOp(name, index, args);
            request.setAttribute("opResultInfo", (Object)opResult);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/displayOpResult.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (JMException e) {
            throw new ServletException("Failed to invoke operation", (Throwable)e);
        }
    }

    private void invokeOpByName(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.trace((Object)("invokeOpByName, name=" + name));
        String[] argTypes = request.getParameterValues("argType");
        String[] args = this.getArgs(request);
        String methodName = request.getParameter("methodName");
        if (methodName == null) {
            throw new ServletException("No methodName given in invokeOpByName form");
        }
        try {
            OpResultInfo opResult = Server.invokeOpByName(name, methodName, argTypes, args);
            request.setAttribute("opResultInfo", (Object)opResult);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/displayOpResult.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (JMException e) {
            throw new ServletException("Failed to invoke operation", (Throwable)e);
        }
    }

    private String[] getArgs(HttpServletRequest request) {
        String name;
        String value;
        ArrayList<String> argList = new ArrayList<String>();
        int i = 0;
        while ((value = request.getParameter(name = "arg" + i)) != null) {
            argList.add(value);
            log.trace((Object)(name + "=" + value));
            ++i;
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        return args;
    }
}

