/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.services.binding.ServiceBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingSet
extends HashSet<ServiceBinding> {
    private static final long serialVersionUID = 765380451233486038L;
    private final String defaultHostName;
    private final InetAddress defaultBindAddress;
    private final int portOffset;

    public ServiceBindingSet(Set<ServiceBinding> base) throws UnknownHostException {
        this(base, 0, null, null);
    }

    public ServiceBindingSet(Set<ServiceBinding> base, int offset) throws UnknownHostException {
        this(base, offset, null, null);
    }

    public ServiceBindingSet(Set<ServiceBinding> base, int offset, String defaultHostName) throws UnknownHostException {
        this(base, offset, null, defaultHostName);
    }

    public ServiceBindingSet(Set<ServiceBinding> base, int offset, Set<ServiceBinding> overrides, String defaultHostName) throws UnknownHostException {
        super(ServiceBindingSet.getOffsetBindings(base, offset));
        if (overrides != null) {
            for (ServiceBinding binding : overrides) {
                this.remove(binding);
                this.add(binding);
            }
        }
        this.defaultHostName = defaultHostName;
        this.defaultBindAddress = defaultHostName == null ? null : InetAddress.getByName(defaultHostName);
        this.portOffset = offset;
    }

    private static Set<ServiceBinding> getOffsetBindings(Set<ServiceBinding> base, int offset) throws UnknownHostException {
        HashSet<ServiceBinding> altered = new HashSet<ServiceBinding>(base.size());
        for (ServiceBinding binding : base) {
            altered.add(binding.getOffsetBinding(offset));
        }
        return altered;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public InetAddress getDefaultBindAddress() {
        return this.defaultBindAddress;
    }

    public int getPortOffset() {
        return this.portOffset;
    }
}

