/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.services.binding.ElementServiceBindingValueSource;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.URLServiceBindingValueSource;
import org.jboss.services.binding.impl.Util;
import org.jboss.services.binding.impl.XSLTServiceBindingValueSourceConfig;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;

public class XSLTServiceBindingValueSourceImpl
implements URLServiceBindingValueSource,
ElementServiceBindingValueSource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceServiceBindingValue(ServiceBinding binding, String input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        XSLTServiceBindingValueSourceConfig config = this.getConfig(binding);
        InputStreamReader reader = null;
        Writer writer = null;
        try {
            reader = Util.getInputStreamReader(input);
            File targetFile = Util.createTempFile();
            writer = new OutputStreamWriter(new FileOutputStream(targetFile));
            this.doXslTransform(binding, config, reader, writer);
            String string = targetFile.getAbsolutePath();
            return string;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURLServiceBindingValue(ServiceBinding binding, URL input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        XSLTServiceBindingValueSourceConfig config = this.getConfig(binding);
        InputStreamReader reader = null;
        Writer writer = null;
        try {
            reader = Util.getInputStreamReader(input);
            File targetFile = Util.createTempFile();
            writer = new OutputStreamWriter(new FileOutputStream(targetFile));
            this.doXslTransform(binding, config, reader, writer);
            URL uRL = targetFile.toURL();
            return uRL;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public Element getElementServiceBindingValue(ServiceBinding binding, Element input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(Element.class);
        if (editor == null) {
            throw new IllegalStateException("Cannot find PropertyEditor for type Element");
        }
        editor.setValue(input);
        StringReader reader = new StringReader(editor.getAsText());
        StringWriter writer = new StringWriter();
        this.doXslTransform(binding, this.getConfig(binding), reader, writer);
        editor.setAsText(((Object)writer).toString());
        return (Element)editor.getValue();
    }

    public Object getServiceBindingValue(ServiceBinding binding, Object ... params) throws Exception {
        if (params == null || params.length != 1) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".getServiceBindingValue() requires a single-value 'params'");
        }
        if (params[0] instanceof String) {
            return this.getResourceServiceBindingValue(binding, (String)params[0]);
        }
        if (params[0] instanceof Element) {
            return this.getElementServiceBindingValue(binding, (Element)params[0]);
        }
        if (params[0] instanceof URL) {
            return this.getURLServiceBindingValue(binding, (URL)params[0]);
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + ".getServiceBindingValue() requires a single-value 'params' of type String, Element or URL");
    }

    private XSLTServiceBindingValueSourceConfig getConfig(ServiceBinding binding) {
        Object config = binding.getServiceBindingValueSourceConfig();
        if (config instanceof XSLTServiceBindingValueSourceConfig) {
            return (XSLTServiceBindingValueSourceConfig)config;
        }
        if (config == null) {
            throw new IllegalStateException("No config object bound to " + binding);
        }
        throw new IllegalStateException("Incompatible config object of type " + config.getClass() + " bound to " + binding + " -- must use " + XSLTServiceBindingValueSourceConfig.class.getName());
    }

    private void doXslTransform(ServiceBinding binding, XSLTServiceBindingValueSourceConfig config, Reader reader, Writer writer) throws TransformerException {
        StreamSource xmlSource = new StreamSource(reader);
        StreamResult xmlResult = new StreamResult(writer);
        StreamSource xslSource = new StreamSource(new StringReader(config.getXslt()));
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslSource);
        transformer.setParameter("port", new Integer(binding.getPort()));
        String host = binding.getHostName();
        if (host != null) {
            transformer.setParameter("host", host);
        }
        Map<String, String> attributes = config.getAdditionalAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attrValue = StringPropertyReplacer.replaceProperties((String)entry.getValue());
            transformer.setParameter(entry.getKey(), attrValue);
        }
        transformer.transform(xmlSource, xmlResult);
    }
}

