/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jboss.bootstrap.spi.ServerConfig;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.Files;

public final class LibraryManager {
    private static final Logger log = Logger.getLogger(LibraryManager.class);
    private static final LibraryManager INSTANCE = new LibraryManager();
    File serverLibDir;
    File serverTmpDir;

    private LibraryManager() {
        ServerConfig config = ServerConfigLocator.locate();
        URL serverLibURL = config.getServerLibraryURL();
        if (serverLibURL != null && serverLibURL.getProtocol().startsWith("file")) {
            this.serverLibDir = new File(serverLibURL.getFile());
            this.serverTmpDir = config.getServerTempDir();
            log.debug((Object)("Using serverLibDir: " + this.serverLibDir));
            log.debug((Object)("Using serverTmpDir: " + this.serverTmpDir));
        } else {
            log.info((Object)("Cannot manage remote serverLibraryURL: " + serverLibURL));
        }
    }

    public static LibraryManager getInstance() {
        return INSTANCE;
    }

    public boolean uploadLibrary(URL src, String filename) {
        if (src != null) {
            log.debug((Object)("Uploading from URL: " + src));
            if (filename == null || filename.equals("")) {
                filename = new File(src.getPath()).getName();
                log.debug((Object)("Null or empty target filename, using basename: " + filename));
            } else {
                log.debug((Object)("Using target filename: " + filename));
            }
            File target = new File(this.serverLibDir, filename);
            if (!target.exists()) {
                try {
                    Files.copy((URL)src, (File)target);
                    return true;
                }
                catch (IOException e) {
                    log.warn((Object)("Could not upload target library: " + filename), (Throwable)e);
                }
            } else {
                log.warn((Object)("Target library exists: " + filename));
            }
        } else {
            log.warn((Object)"Null src URL");
        }
        return false;
    }
}

