/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netboot;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TrivialDavFilter
implements Filter {
    private ServletContext context;
    private SimpleDateFormat sharedFormat;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        this.sharedFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        this.sharedFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        String method = hrequest.getMethod();
        if ("PROPFIND".equals(method)) {
            this.doPropfind(hrequest, (HttpServletResponse)response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.sharedFormat = null;
        this.context = null;
    }

    private void doPropfind(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = request.getContextPath();
        String path = request.getRequestURI().substring(contextPath.length());
        if (path.startsWith("/WEB-INF") || this.context.getResource(path) == null) {
            response.sendError(404);
            return;
        }
        Set resourcePaths = this.context.getResourcePaths(path);
        if (resourcePaths == null) {
            response.sendError(404);
            return;
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)this.sharedFormat.clone();
        response.setStatus(207);
        PrintWriter out = response.getWriter();
        out.println("<?xml version='1.0' encoding='utf-8' ?>");
        out.println("<D:multistatus xmlns:D='DAV:'>");
        if (resourcePaths.isEmpty()) {
            this.writeResponse(out, contextPath, path, dateFormat);
        } else {
            for (String s : resourcePaths) {
                this.writeResponse(out, contextPath, s, dateFormat);
            }
        }
        out.println("</D:multistatus>");
        out.flush();
        response.flushBuffer();
    }

    private void writeResponse(PrintWriter out, String contextPath, String path, SimpleDateFormat dateFormat) throws IOException {
        Date lastModified = new Date(this.context.getResource(path).openConnection().getLastModified());
        out.println("<D:response>");
        out.println("<D:href>" + contextPath + path + "</D:href>");
        out.println("<D:propstat>");
        out.println("<D:prop>");
        if (path.endsWith("/")) {
            out.println("<D:resourcetype><D:collection/></D:resourcetype>");
        } else {
            out.println("<D:resourcetype/>");
        }
        out.println("<D:getlastmodified>" + dateFormat.format(lastModified) + "</D:getlastmodified>");
        out.println("</D:prop>");
        out.println("<D:status>HTTP/1.1 200 OK</D:status>");
        out.println("</D:propstat>");
        out.println("</D:response>");
    }
}

