/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment.convertor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.varia.deployment.convertor.XslTransformer;

public class JarTransformer {
    private static Logger log = Logger.getLogger(JarTransformer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(File root, Properties globalXslParams) throws Exception {
        Properties xslParams = new Properties(globalXslParams);
        File metaInf = new File(root, "META-INF");
        if (!metaInf.exists()) {
            return;
        }
        File ejbjar = new File(metaInf, "ejb-jar.xml");
        if (ejbjar.exists()) {
            xslParams.setProperty("ejb-jar", ejbjar.getAbsolutePath());
        }
        File[] files = metaInf.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".xml") && !file.isDirectory();
            }
        });
        log.debug((Object)("list XML files: " + Arrays.asList(files)));
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String xmlName = file.getName();
            String xslName = xslParams.getProperty("resources_path") + xmlName.substring(0, xmlName.length() - 3) + "xsl";
            String propsName = xslParams.getProperty("resources_path") + xmlName.substring(0, xmlName.length() - 4) + "-output.properties";
            InputStream templateIs = null;
            try {
                templateIs = JarTransformer.class.getClassLoader().getResource(xslName).openStream();
            }
            catch (Exception e) {
                log.debug((Object)("xsl template wasn't found for '" + xmlName + "'"));
                continue;
            }
            log.debug((Object)("Attempt to transform '" + xmlName + "' with '" + xslName + "'"));
            Properties outputProps = JarTransformer.loadProperties(propsName);
            FileInputStream input = null;
            OutputStream output = null;
            try {
                input = new FileInputStream(file);
                byte[] bytes = JarTransformer.readBytes(input);
                ((InputStream)input).close();
                bytes = JarTransformer.transformBytes(bytes, templateIs, outputProps, xslParams);
                String entryname = null;
                if (outputProps != null) {
                    entryname = outputProps.getProperty("newname");
                }
                if (entryname == null) {
                    entryname = file.getName();
                }
                output = new FileOutputStream(new File(root, entryname));
                JarTransformer.writeBytes(output, bytes);
                log.debug((Object)("Entry '" + file.getName() + "' transformed to '" + entryname + "'"));
                continue;
            }
            catch (Exception e) {
                log.debug((Object)("Exception while transforming entry '" + file.getName()), (Throwable)e);
                continue;
            }
            finally {
                if (templateIs != null) {
                    try {
                        templateIs.close();
                    }
                    catch (Exception e) {}
                }
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Exception e) {}
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propsName) {
        Properties props = new Properties();
        InputStream propsIs = null;
        try {
            propsIs = JarTransformer.class.getClassLoader().getResource(propsName).openStream();
            props.load(propsIs);
            log.debug((Object)("Loaded properties '" + propsName + "'"));
        }
        catch (Exception e) {
            log.debug((Object)("Couldn't find properties '" + propsName + "'"));
        }
        finally {
            if (propsIs != null) {
                try {
                    propsIs.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transformBytes(byte[] bytes, InputStream xslIs, Properties outputprops) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            XslTransformer.applyTransformation(bais, baos, xslIs, outputprops);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transformBytes(byte[] bytes, InputStream xslIs, Properties outputProps, Properties xslParams) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            XslTransformer.applyTransformation(bais, baos, xslIs, outputProps, xslParams);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        }
        return baos.toByteArray();
    }

    private static void writeBytes(OutputStream os, byte[] bytes) throws Exception {
        os.write(bytes, 0, bytes.length);
        os.flush();
    }

    private static int copyBytes(InputStream is, OutputStream os) throws Exception {
        byte[] buffer = JarTransformer.readBytes(is);
        os.write(buffer, 0, buffer.length);
        os.flush();
        return buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(InputStream is) throws IOException {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        try {
            int n;
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, n);
            }
            buffer = baos.toByteArray();
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        }
        return buffer;
    }
}

