/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mail;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionObjectFactory
implements ObjectFactory {
    private static final Map<String, MailSessionConfig> mailSessions = new HashMap<String, MailSessionConfig>();

    static void setSessionFactoryInfo(String bindName, Properties props, Authenticator auth, boolean shareSessionInstance) {
        mailSessions.put(bindName, new MailSessionConfig(props, auth, shareSessionInstance));
    }

    static void remove(String bindName) {
        mailSessions.remove(bindName);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String addressValue;
        Reference ref;
        RefAddr address;
        String nameStr = null;
        if (obj != null && obj instanceof Reference && (address = (ref = (Reference)obj).get("nns")) != null && (addressValue = address.getContent().toString()) != null) {
            nameStr = addressValue;
        }
        if (nameStr == null && name != null) {
            nameStr = name.toString();
        }
        if (nameStr == null) {
            if (mailSessions.containsKey("java:/Mail")) {
                nameStr = "java:/Mail";
            } else {
                throw new IllegalStateException("No default mail session found and no alternative jndi name provided.");
            }
        }
        MailSessionConfig config = mailSessions.get(nameStr);
        return config.getSession();
    }

    private static class MailSessionConfig {
        private Properties properties;
        private Authenticator auth;
        private boolean shareSessionInstance = false;
        private Session session;

        protected MailSessionConfig(Properties properties, Authenticator auth, boolean shareSessionInstance) {
            this.properties = properties;
            this.auth = auth;
            this.shareSessionInstance = shareSessionInstance;
        }

        public Authenticator getAuth() {
            return this.auth;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Session getSession() {
            if (this.isShareSessionInstance()) {
                if (this.session == null) {
                    this.session = Session.getInstance((Properties)this.getProperties(), (Authenticator)this.getAuth());
                }
                return this.session;
            }
            return Session.getInstance((Properties)this.getProperties(), (Authenticator)this.getAuth());
        }

        public boolean isShareSessionInstance() {
            return this.shareSessionInstance;
        }
    }
}

