/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.metadata;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.webservices.integration.metadata.PublishLocationAdapterImpl;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.wsf.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetaDataBuilderJSE {
    private final Logger log = Logger.getLogger(MetaDataBuilderJSE.class);

    MetaDataBuilderJSE() {
    }

    JSEArchiveMetaData create(Deployment dep) {
        JBossWebMetaData jbossWebMD = (JBossWebMetaData)WSHelper.getRequiredAttachment((Deployment)dep, JBossWebMetaData.class);
        JSEArchiveMetaData jseArchiveMD = new JSEArchiveMetaData();
        String contextRoot = this.getContextRoot(dep, jbossWebMD);
        jseArchiveMD.setContextRoot(contextRoot);
        Map<String, String> servletMappings = this.getServletUrlPatternsMappings(jbossWebMD);
        jseArchiveMD.setServletMappings(servletMappings);
        Map<String, String> servletClassNamesMappings = this.getServletClassMappings(jbossWebMD);
        jseArchiveMD.setServletClassNames(servletClassNamesMappings);
        String securityDomain = jbossWebMD.getSecurityDomain();
        jseArchiveMD.setSecurityDomain(securityDomain);
        PublishLocationAdapterImpl resolver = new PublishLocationAdapterImpl(jbossWebMD.getWebserviceDescriptions());
        jseArchiveMD.setPublishLocationAdapter((PublishLocationAdapter)resolver);
        List<JSESecurityMetaData> jseSecurityMDs = this.getSecurityMetaData(jbossWebMD.getSecurityContraints());
        jseArchiveMD.setSecurityMetaData(jseSecurityMDs);
        this.setConfigNameAndFile(jseArchiveMD, jbossWebMD);
        return jseArchiveMD;
    }

    private void setConfigNameAndFile(JSEArchiveMetaData jseArchiveMD, JBossWebMetaData jbossWebMD) {
        WebserviceDescriptionsMetaData wsDescriptionsMD = jbossWebMD.getWebserviceDescriptions();
        WebserviceDescriptionMetaData wsDescriptionMD = ASHelper.getWebserviceDescriptionMetaData(wsDescriptionsMD);
        if (wsDescriptionMD != null && wsDescriptionMD.getConfigName() != null) {
            jseArchiveMD.setConfigName(wsDescriptionMD.getConfigName());
            jseArchiveMD.setConfigFile(wsDescriptionMD.getConfigFile());
            return;
        }
        List contextParams = jbossWebMD.getContextParams();
        if (contextParams != null) {
            for (ParamValueMetaData contextParam : contextParams) {
                if ("jbossws-config-name".equals(contextParam.getParamName())) {
                    jseArchiveMD.setConfigName(contextParam.getParamValue());
                }
                if (!"jbossws-config-file".equals(contextParam.getParamName())) continue;
                jseArchiveMD.setConfigFile(contextParam.getParamValue());
            }
        }
    }

    private List<JSESecurityMetaData> getSecurityMetaData(List<SecurityConstraintMetaData> securityConstraintsMD) {
        LinkedList<JSESecurityMetaData> jseSecurityMDs = new LinkedList<JSESecurityMetaData>();
        if (securityConstraintsMD != null) {
            for (SecurityConstraintMetaData securityConstraintMD : securityConstraintsMD) {
                JSESecurityMetaData jseSecurityMD = new JSESecurityMetaData();
                jseSecurityMD.setTransportGuarantee(securityConstraintMD.getTransportGuarantee().name());
                this.setWebResources(jseSecurityMD, securityConstraintMD);
                jseSecurityMDs.add(jseSecurityMD);
            }
        }
        return jseSecurityMDs;
    }

    private void setWebResources(JSESecurityMetaData jseSecurityMD, SecurityConstraintMetaData securityConstraintMD) {
        WebResourceCollectionsMetaData webResources = securityConstraintMD.getResourceCollections();
        for (WebResourceCollectionMetaData webResourceMD : webResources) {
            JSESecurityMetaData.JSEResourceCollection jseResource = jseSecurityMD.addWebResource(webResourceMD.getName());
            for (String webResourceUrlPatterns : webResourceMD.getUrlPatterns()) {
                jseResource.addPattern(webResourceUrlPatterns);
            }
        }
    }

    private Map<String, String> getServletUrlPatternsMappings(JBossWebMetaData jbossWebMD) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        List servletMappings = jbossWebMD.getServletMappings();
        if (servletMappings != null) {
            for (ServletMappingMetaData mapping : servletMappings) {
                mappings.put(mapping.getServletName(), (String)mapping.getUrlPatterns().get(0));
            }
        }
        return mappings;
    }

    private Map<String, String> getServletClassMappings(JBossWebMetaData jbossWebMD) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        JBossServletsMetaData servlets = jbossWebMD.getServlets();
        if (servlets != null) {
            for (JBossServletMetaData servlet : servlets) {
                if (servlet.getServletClass() == null || servlet.getServletClass().trim().length() == 0) continue;
                this.log.debug((Object)("Creating JBoss agnostic JSE meta data for POJO bean: " + servlet.getServletClass()));
                mappings.put(servlet.getName(), servlet.getServletClass());
            }
        }
        return mappings;
    }

    private String getContextRoot(Deployment dep, JBossWebMetaData jbossWebMD) {
        ModuleMetaData moduleMD;
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        JBossAppMetaData jbossAppMD = unit.getParent() == null ? null : ASHelper.getOptionalAttachment(unit.getParent(), JBossAppMetaData.class);
        String contextRoot = null;
        if (jbossAppMD != null && (moduleMD = jbossAppMD.getModule(dep.getSimpleName())) != null) {
            WebModuleMetaData webModuleMD = (WebModuleMetaData)moduleMD.getValue();
            contextRoot = webModuleMD.getContextRoot();
        }
        return contextRoot != null ? contextRoot : jbossWebMD.getContextRoot();
    }
}

