/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanServer;
import org.jboss.jmx.adaptor.snmp.agent.BindEntry;
import org.jboss.jmx.adaptor.snmp.config.attribute.ManagedBean;
import org.jboss.jmx.adaptor.snmp.config.attribute.MappedAttribute;
import org.jboss.logging.Logger;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class AttributeTableMapper {
    private SortedSet<OID> tables = new TreeSet<OID>();
    private SortedMap<OID, BindEntry> tableMappings = new TreeMap<OID, BindEntry>();
    private MBeanServer server;
    private Logger log;

    public AttributeTableMapper(MBeanServer server, Logger log) {
        this.server = server;
        this.log = log;
    }

    public BindEntry getTableBinding(OID oid, boolean isRowEntry) {
        Set<Map.Entry<OID, BindEntry>> entries = null;
        entries = this.tableMappings.entrySet();
        for (Map.Entry<OID, BindEntry> entry : entries) {
            if (!oid.startsWith(entry.getKey())) continue;
            BindEntry value = entry.getValue();
            BindEntry bindEntry = value.clone();
            int[] oidValue = oid.getValue();
            int[] subOid = new int[oid.size() - entry.getKey().size()];
            System.arraycopy(oidValue, entry.getKey().size(), subOid, 0, oid.size() - entry.getKey().size());
            if (subOid.length > 0) {
                bindEntry.setTableIndexOID(new OID(subOid));
            }
            return bindEntry;
        }
        return null;
    }

    public OID getNextTable(OID oid) {
        BindEntry be;
        OID currentOID = (OID)oid.clone();
        boolean isRowEntry = false;
        if (this.tables.contains(oid)) {
            currentOID = oid.append(1);
        }
        if ((be = this.getTableBinding(currentOID, isRowEntry)) == null) {
            return null;
        }
        Object val = null;
        try {
            val = this.server.getAttribute(be.getMbean(), be.getAttr().getName());
        }
        catch (Exception e) {
            this.log.error((Object)("Impossible to fetch " + be.getAttr().getName()));
            return null;
        }
        OID tableIndexOID = be.getTableIndexOID();
        if (tableIndexOID == null) {
            if (val instanceof Map) {
                TreeSet keySet = new TreeSet(((Map)val).keySet());
                if (keySet.size() > 0) {
                    return new OID(currentOID.append(2).append("'" + keySet.iterator().next().toString() + "'"));
                }
                return null;
            }
            return new OID(currentOID).append(2).append(1);
        }
        if (val instanceof List) {
            int index = Integer.valueOf(tableIndexOID.toString().substring(2));
            if (index - 1 < 0) {
                return null;
            }
            if (++index <= ((List)val).size()) {
                return new OID(currentOID.trim().append(index));
            }
            return null;
        }
        if (val instanceof Map) {
            String key = new String(new OID(tableIndexOID.toString().substring(2)).toByteArray());
            Iterator keySet = new TreeSet(((Map)val).keySet()).iterator();
            while (keySet.hasNext()) {
                Object entryKey = keySet.next();
                if (!entryKey.equals(key)) continue;
                if (keySet.hasNext()) {
                    Object nextKey = keySet.next();
                    OID nextOID = new OID(currentOID);
                    nextOID.trim(tableIndexOID.size());
                    nextOID.append(2).append("'" + nextKey + "'");
                    return nextOID;
                }
                return null;
            }
            return null;
        }
        if (val instanceof int[]) {
            int index = Integer.valueOf(tableIndexOID.toString().substring(2));
            if (index - 1 < 0) {
                return null;
            }
            if (++index <= ((int[])val).length) {
                return new OID(currentOID.trim().append(index));
            }
            if (isRowEntry) {
                return new OID(currentOID.trim().trim().append(2).append(1));
            }
            return null;
        }
        if (val instanceof long[]) {
            int index = Integer.valueOf(tableIndexOID.toString().substring(2));
            if (index - 1 < 0) {
                return null;
            }
            if (++index <= ((long[])val).length) {
                return new OID(currentOID.trim().append(index));
            }
            if (isRowEntry) {
                return new OID(currentOID.trim().trim().append(2).append(1));
            }
            return null;
        }
        if (val instanceof boolean[]) {
            int index = Integer.valueOf(tableIndexOID.toString().substring(2));
            if (index - 1 < 0) {
                return null;
            }
            if (++index <= ((boolean[])val).length) {
                return new OID(currentOID.trim().append(index));
            }
            if (isRowEntry) {
                return new OID(currentOID.trim().trim().append(2).append(1));
            }
            return null;
        }
        if (val instanceof Object[]) {
            int index = Integer.valueOf(tableIndexOID.toString().substring(2));
            if (index - 1 < 0) {
                return null;
            }
            if (++index <= ((Object[])val).length) {
                return new OID(currentOID.trim().append(index));
            }
            if (isRowEntry) {
                return new OID(currentOID.trim().trim().append(2).append(1));
            }
            return null;
        }
        return null;
    }

    public void addTableMapping(ManagedBean mmb, MappedAttribute ma) {
        String oidPrefix = mmb.getOidPrefix();
        String oid = oidPrefix != null ? oidPrefix + ma.getOid() : ma.getOid();
        OID coid = new OID(oid);
        BindEntry be = new BindEntry(coid, mmb.getName(), ma.getName());
        be.setReadWrite(ma.isReadWrite());
        be.setTable(ma.isAttributeTable());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("New bind entry   " + be));
        }
        if (this.tables.contains(coid)) {
            this.log.info((Object)("Duplicate oid " + coid + " - skipping entry"));
        }
        if (mmb == null || mmb.equals("")) {
            this.log.info((Object)("Invalid mbean name for oid " + coid + " - skipping entry"));
        }
        if (ma == null || ma.equals("")) {
            this.log.info((Object)("Invalid attribute name " + ma + " for oid " + coid + " - skipping entry"));
        }
        this.tables.add(coid.trim());
        this.tableMappings.put(new OID(coid), be);
    }

    public boolean belongsToTables(OID oid) {
        for (OID attributeOID : this.tables) {
            if (!oid.startsWith(attributeOID)) continue;
            return true;
        }
        return false;
    }

    public void removeTableMapping(ManagedBean mmb, MappedAttribute ma) {
    }

    public Variable getIndexValue(OID oid) {
        BindEntry be = this.getTableBinding(oid, true);
        Object val = null;
        if (be == null) {
            return null;
        }
        try {
            val = this.server.getAttribute(be.getMbean(), be.getAttr().getName());
        }
        catch (Exception e) {
            this.log.error((Object)("Impossible to fetch " + be.getAttr().getName()));
            return null;
        }
        OID tableIndexOID = be.getTableIndexOID();
        if (val instanceof List) {
            return new OctetString("" + oid.get(oid.size() - 1));
        }
        if (val instanceof Map) {
            int index = oid.get(oid.size() - 1);
            int i = 1;
            for (Object key : ((Map)val).keySet()) {
                if (i == index) {
                    return new OctetString((String)key);
                }
                ++i;
            }
        }
        if (val instanceof int[]) {
            return new OctetString("" + oid.get(oid.size() - 1));
        }
        if (val instanceof long[]) {
            return new OctetString("" + oid.get(oid.size() - 1));
        }
        if (val instanceof boolean[]) {
            return new OctetString("" + oid.get(oid.size() - 1));
        }
        if (val instanceof Object[]) {
            return new OctetString("" + oid.get(oid.size() - 1));
        }
        return null;
    }
}

