/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import javax.management.Attribute;
import javax.management.ObjectName;
import org.snmp4j.smi.OID;

public class BindEntry
implements Comparable {
    private final OID oid;
    private ObjectName mbean;
    private Attribute attr;
    private String mName;
    private String aName;
    private boolean isReadWrite = false;
    private boolean isTable = false;
    private OID tableIndexOID;

    BindEntry(OID coid, String mbName, String attrName) {
        this.oid = coid;
        this.mName = mbName;
        this.aName = attrName;
        try {
            this.setMbean(new ObjectName(mbName));
            this.setAttr(new Attribute(attrName, null));
        }
        catch (Exception e) {
            this.mName = "-unset-";
            this.aName = "-unset-";
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[oid=");
        buf.append(this.oid).append(", mbean=");
        buf.append(this.mName).append(", attr=");
        buf.append(this.aName).append(", rw=");
        buf.append(", table=").append(this.isTable());
        buf.append(this.isReadWrite()).append("]");
        return buf.toString();
    }

    public Attribute getAttr() {
        return this.attr;
    }

    public ObjectName getMbean() {
        return this.mbean;
    }

    public OID getOid() {
        return this.oid;
    }

    public int compareTo(Object other) {
        if (other == null) {
            throw new NullPointerException("Can't compare to NULL");
        }
        if (!(other instanceof BindEntry)) {
            throw new ClassCastException("Parameter is no BindEntry");
        }
        if (this.equals(other)) {
            return 0;
        }
        BindEntry obe = (BindEntry)other;
        int res = this.oid.compareTo((Object)obe.getOid());
        return res;
    }

    public void setReadWrite(boolean isReadWrite) {
        this.isReadWrite = isReadWrite;
    }

    public boolean isReadWrite() {
        return this.isReadWrite;
    }

    public void setMbean(ObjectName mbean) {
        this.mbean = mbean;
    }

    public void setAttr(Attribute attr) {
        this.attr = attr;
    }

    public void setTable(boolean isTable) {
        this.isTable = isTable;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public void setTableIndexOID(OID tableIndexOID) {
        this.tableIndexOID = tableIndexOID;
    }

    public OID getTableIndexOID() {
        return this.tableIndexOID;
    }

    protected BindEntry clone() {
        BindEntry bindEntry = new BindEntry(this.oid, this.mName, this.aName);
        bindEntry.setAttr(this.attr);
        bindEntry.setMbean(this.mbean);
        bindEntry.setReadWrite(this.isReadWrite);
        bindEntry.setTable(this.isTable);
        return bindEntry;
    }
}

