/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import org.jboss.jmx.adaptor.snmp.agent.RequestHandler;
import org.jboss.logging.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.OctetString;

public class SnmpRequest
implements CommandResponder {
    protected Logger log;
    private RequestHandler requestHandler;
    private OctetString localContextEngineID;

    public SnmpRequest(RequestHandler requestHandler, Logger log) {
        this.requestHandler = requestHandler;
        this.log = log;
    }

    public SnmpRequest(RequestHandler requestHandler, Logger log, OctetString ceID) {
        this.requestHandler = requestHandler;
        this.log = log;
        this.localContextEngineID = ceID;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu == null) {
            this.log.warn((Object)"Null request PDU received ... skipping");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received Snmp request of type: " + PDU.getTypeString((int)pdu.getType())));
        }
        int type = pdu.getType();
        PDU response = null;
        switch (type) {
            case -96: 
            case -95: {
                response = this.requestHandler.snmpReceivedGet(pdu);
                break;
            }
            case -91: {
                response = this.requestHandler.snmpReceivedGetBulk(pdu);
                break;
            }
            case -93: {
                response = this.requestHandler.snmpReceivedSet(pdu);
                break;
            }
            default: {
                this.log.warn((Object)("Cannot process request PDU of type: " + PDU.getTypeString((int)type) + "unsupported"));
                return;
            }
        }
        if (response != null) {
            response.setRequestID(event.getPDU().getRequestID());
            try {
                this.sendResponse(event, response);
            }
            catch (MessageException e) {
                this.log.warn((Object)("Response may not have been sent correctly. An error occured snmp4j message processing: " + e.getMessage()));
            }
        }
    }

    private void sendResponse(CommandResponderEvent requestEvent, PDU response) throws MessageException {
        response.setType(-94);
        StatusInformation statusInformation = new StatusInformation();
        StateReference ref = requestEvent.getStateReference();
        requestEvent.getMessageDispatcher().returnResponsePdu(requestEvent.getMessageProcessingModel(), requestEvent.getSecurityModel(), requestEvent.getSecurityName(), requestEvent.getSecurityLevel(), response, requestEvent.getMaxSizeResponsePDU(), ref, statusInformation);
    }

    public OctetString getLocalEngineID() {
        return this.localContextEngineID;
    }
}

