/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jmx.adaptor.snmp.agent.BindEntry;
import org.jboss.jmx.adaptor.snmp.config.attribute.ManagedBean;
import org.jboss.jmx.adaptor.snmp.config.attribute.MappedAttribute;
import org.jboss.logging.Logger;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMapper {
    private SortedMap<OID, ManagedBean> tables = new TreeMap<OID, ManagedBean>();
    private SortedMap<OID, BindEntry> tableBindings = new TreeMap<OID, BindEntry>();
    private SortedMap<OID, OID> tableIndexes = new TreeMap<OID, OID>();
    private SortedMap<OID, Variable> objectNameIndexes = new TreeMap<OID, Variable>();
    private MBeanServer server;
    private Logger log;

    public TableMapper(MBeanServer server, Logger log) {
        this.server = server;
        this.log = log;
    }

    public BindEntry getTableBinding(OID oid) {
        return (BindEntry)this.tableBindings.get(oid);
    }

    public OID getNextTable(OID oid) {
        return (OID)this.tableIndexes.get(oid);
    }

    public Variable getObjectNameIndexValue(OID oid) {
        return (Variable)this.objectNameIndexes.get(oid);
    }

    public void addTableMapping(ManagedBean mmb, ObjectName oname) {
        this.tables.put(new OID(mmb.getOidPrefix().substring(0, mmb.getOidPrefix().lastIndexOf("."))), mmb);
        Set<ObjectName> mbeanNames = this.server.queryNames(oname, null);
        if (mbeanNames.size() > 0) {
            this.createMappings(mbeanNames, mmb.getAttributes(), mmb.getOidPrefix());
        }
    }

    private void createMappings(Set<ObjectName> mbeanNames, List<MappedAttribute> attrs, String tableOid) {
        boolean firstColumnIndexSet = false;
        TreeSet<String> onameStrings = new TreeSet<String>();
        for (ObjectName oname : mbeanNames) {
            onameStrings.add(oname.toString());
        }
        String previousMBeanName = null;
        String lastMBeanName = (String)onameStrings.last();
        OID firstOID = null;
        for (String mbeanRealName : onameStrings) {
            String previousAttribute = null;
            for (MappedAttribute ma : attrs) {
                String oid = tableOid;
                String columnOid = oid + ma.getOid();
                String previousOid = null;
                String fullOid = columnOid + ".'" + mbeanRealName + "'";
                if (previousMBeanName != null) {
                    previousOid = columnOid + ".'" + previousMBeanName + "'";
                }
                OID coid = new OID(fullOid);
                this.addBindEntry(coid, mbeanRealName, ma.getName(), ma.isReadWrite());
                if (previousOid != null) {
                    OID previousOID = new OID(previousOid);
                    this.tableIndexes.put(previousOID, coid);
                }
                if (firstOID == null) {
                    firstOID = coid;
                }
                if (!firstColumnIndexSet) {
                    this.tableIndexes.put(new OID(oid + ma.getOid()), coid);
                    if (previousAttribute != null) {
                        String lastRowOID = oid + previousAttribute + ".'" + lastMBeanName + "'";
                        this.tableIndexes.put(new OID(lastRowOID), coid);
                    }
                }
                previousAttribute = ma.getOid();
            }
            firstColumnIndexSet = true;
            previousMBeanName = mbeanRealName;
        }
        this.tableIndexes.put(new OID(tableOid), firstOID);
        this.tableIndexes.put(new OID(tableOid.substring(0, tableOid.lastIndexOf("."))), firstOID);
    }

    private void addBindEntry(OID coid, String mmb, String ma, boolean rw) {
        BindEntry be = new BindEntry(coid, mmb, ma);
        be.setReadWrite(rw);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("New bind entry   " + be));
        }
        if (this.tableBindings.containsKey(coid)) {
            this.log.info((Object)("Duplicate oid " + coid + " - skipping entry"));
        }
        if (mmb == null || mmb.equals("")) {
            this.log.info((Object)("Invalid mbean name for oid " + coid + " - skipping entry"));
        }
        if (ma == null || ma.equals("")) {
            this.log.info((Object)("Invalid attribute name " + ma + " for oid " + coid + " - skipping entry"));
        }
        this.tableBindings.put(coid, be);
    }

    public void checkTables(OID oid) {
        for (Map.Entry<OID, ManagedBean> tableEntry : this.tables.entrySet()) {
            ManagedBean managedBean = tableEntry.getValue();
            if (!oid.startsWith(tableEntry.getKey()) || !this.tableBindings.tailMap(tableEntry.getKey()).isEmpty()) continue;
            ObjectName oname = null;
            try {
                oname = new ObjectName(managedBean.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            Set<ObjectName> mbeanNames = this.server.queryNames(oname, null);
            this.createMappings(mbeanNames, managedBean.getAttributes(), managedBean.getOidPrefix());
        }
    }

    public boolean belongsToTable(OID oid) {
        return this.tableBindings.get(oid) != null;
    }

    public void removeTableMapping(ManagedBean mmb, ObjectName oname) {
    }
}

