/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.test;

import java.io.IOException;
import java.net.UnknownHostException;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Test {
    public static void main(String[] args) {
        if (args[0].equals("get")) {
            Test.get(args);
        } else if (args[0].equals("getnext")) {
            Test.getnext(args);
        } else if (args[0].equals("getbulk")) {
            Test.getbulk();
        } else if (args[0].equals("set")) {
            Test.set(args);
        } else if (args[0].equals("getv3")) {
            Test.getv3();
        } else if (args[0].equals("testnullpdu")) {
            Test.testnull();
        } else {
            System.out.println("*Usage*\n<get/getnext> <oid>\n<set> <oid> <value>\n<getbulk> (test snmpReceivedGetBulk)\n<testnullpdu> (test sending a null pdu)\n");
        }
    }

    public static void getbulk() {
        PDU pdu = new PDU();
        pdu.setType(-91);
        pdu.add(new VariableBinding(new OID("1.2.3.4.1.1")));
        pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1.0")));
        pdu.add(new VariableBinding(new OID("1.3.1.1")));
        pdu.setMaxRepetitions(7);
        pdu.setNonRepeaters(1);
        CommunityTarget target = new CommunityTarget();
        OctetString community = new OctetString("public");
        target.setCommunity(community);
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(0);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            long t1 = System.currentTimeMillis();
            System.out.println("SENDING: " + t1);
            System.out.println("PDU: " + pdu);
            ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
            long t2 = System.currentTimeMillis();
            System.out.println("SENT: " + t2);
            System.out.println("ELAPSED: " + (t2 - t1));
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }

    public static void getv3() {
        ScopedPDU pdu = new ScopedPDU();
        pdu.add(new VariableBinding(new OID("1.3.6")));
        pdu.setType(-95);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        UserTarget target = new UserTarget();
        target.setVersion(3);
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(10000L);
        target.setSecurityLevel(3);
        target.setSecurityName(new OctetString("MD5DES"));
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            long t1 = System.currentTimeMillis();
            System.out.println("SENDING: " + t1);
            System.out.println("PDU: " + pdu);
            ResponseEvent responseEvent = snmp.send((PDU)pdu, (Target)target);
            long t2 = System.currentTimeMillis();
            System.out.println("SENT: " + t2);
            System.out.println("ELAPSED: " + (t2 - t1));
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }

    public static void getnext(String[] oids) {
        ScopedPDU pdu = new ScopedPDU();
        pdu.setType(-95);
        for (int i = 1; i < oids.length; ++i) {
            pdu.add(new VariableBinding(new OID(oids[i])));
        }
        UserTarget target = new UserTarget();
        target.setVersion(3);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            long t1 = System.currentTimeMillis();
            System.out.println("SENDING: " + t1);
            System.out.println("PDU: " + pdu);
            ResponseEvent responseEvent = snmp.send((PDU)pdu, (Target)target);
            long t2 = System.currentTimeMillis();
            System.out.println("SENT: " + t2);
            System.out.println("ELAPSED: " + (t2 - t1));
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }

    public static void testnull() {
        PDU pdu = null;
        CommunityTarget target = new CommunityTarget();
        OctetString community = new OctetString("public");
        target.setCommunity(community);
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            long t1 = System.currentTimeMillis();
            System.out.println("SENDING: " + t1);
            System.out.println("PDU: " + pdu);
            ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
            long t2 = System.currentTimeMillis();
            System.out.println("SENT: " + t2);
            System.out.println("ELAPSED: " + (t2 - t1));
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
            System.out.println("responsePdu = " + responsePDU);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
            System.out.println(e);
        }
    }

    public static void get(String[] oids) {
        PDU pdu = new PDU();
        pdu.setType(-96);
        for (int i = 1; i < oids.length; ++i) {
            pdu.add(new VariableBinding(new OID(oids[i])));
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            long t1 = System.currentTimeMillis();
            System.out.println("SENDING: " + t1);
            System.out.println("PDU: " + pdu);
            ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
            long t2 = System.currentTimeMillis();
            System.out.println("SENT: " + t2);
            System.out.println("ELAPSED: " + (t2 - t1));
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
            System.out.println("responsePdu = " + responsePDU);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!" + e);
        }
    }

    public static void set(String[] oids) {
        PDU pdu = new PDU();
        for (int i = 1; i < oids.length; i += 2) {
            pdu.add(new VariableBinding(new OID(oids[i]), (Variable)new OctetString(oids[i + 1])));
        }
        pdu.setType(-93);
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("private"));
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(1000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            Snmp snmp = new Snmp((TransportMapping)transport);
            long t1 = System.currentTimeMillis();
            System.out.println("SENDING: " + t1);
            System.out.println("PDU: " + pdu);
            ResponseEvent responseEvent = snmp.set(pdu, (Target)target);
            long t2 = System.currentTimeMillis();
            System.out.println("SENT: " + t2);
            System.out.println("ELAPSED: " + (t2 - t1));
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Response is null. Check RequestHandlerImpl");
                System.out.println("Request timed out.");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }
}

