/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.trapd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.jmx.adaptor.snmp.trapd.TrapdServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TrapdService
extends ServiceMBeanSupport
implements TrapdServiceMBean,
CommandResponder {
    private int port;
    private InetAddress bindAddress;
    protected Snmp snmp;

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = this.toInetAddress(host);
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    protected void startService() throws Exception {
        InetAddress address = this.bindAddress != null ? this.bindAddress : this.toInetAddress(System.getProperty("jboss.bind.address"));
        MessageDispatcherImpl mtDispatcher = new MessageDispatcherImpl();
        mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        mtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv3());
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(address, this.port));
        this.snmp = new Snmp((MessageDispatcher)mtDispatcher, (TransportMapping)transport);
        this.snmp.addCommandResponder((CommandResponder)this);
        this.snmp.listen();
        this.log.debug((Object)("listening on: " + address));
    }

    protected void stopService() throws Exception {
        this.snmp.close();
    }

    private InetAddress toInetAddress(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }

    public void processPdu(CommandResponderEvent e) {
        PDU pdu = e.getPDU();
        if (pdu != null) {
            if (pdu instanceof PDUv1) {
                this.processPDUv1((PDUv1)pdu);
            } else if (pdu instanceof ScopedPDU) {
                this.processScopedPDU((ScopedPDU)pdu);
            } else if (pdu instanceof PDU) {
                this.processPDUv2c(pdu);
            } else {
                this.log.warn((Object)("Unknown PDU type: " + PDU.getTypeString((int)pdu.getType())));
            }
        }
    }

    private void processPDUv2c(PDU pdu) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\nV2 Trap from agent ").append(this.bindAddress.toString());
        sbuf.append(" on port ").append(this.port);
        sbuf.append("\n");
        Vector bindings = pdu.getVariableBindings();
        Iterator it = bindings.iterator();
        int counter = 0;
        while (it.hasNext()) {
            VariableBinding vb = (VariableBinding)it.next();
            if (vb == null) continue;
            sbuf.append("Varbind[").append(counter++).append("] := ");
            sbuf.append(vb.getOid().toString()).append(" --> ");
            sbuf.append(vb.getVariable().toString()).append("\n");
        }
        sbuf.append("\nLength............. ").append(counter);
        this.log.debug((Object)sbuf.toString());
    }

    private void processScopedPDU(ScopedPDU pdu) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\nV3 Trap from agent ").append(this.bindAddress.toString());
        sbuf.append(" on port ").append(this.port);
        sbuf.append("\n");
        Vector bindings = pdu.getVariableBindings();
        Iterator it = bindings.iterator();
        int counter = 0;
        while (it.hasNext()) {
            VariableBinding vb = (VariableBinding)it.next();
            if (vb == null) continue;
            sbuf.append("Varbind[").append(counter++).append("] := ");
            sbuf.append(vb.getOid().toString()).append(" --> ");
            sbuf.append(vb.getVariable().toString()).append("\n");
        }
        sbuf.append("\nLength............. ").append(counter);
        this.log.debug((Object)sbuf.toString());
    }

    private void processPDUv1(PDUv1 pdu) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\nV1 Trap from agent ").append(this.bindAddress.toString());
        sbuf.append(" on port ").append(this.port);
        sbuf.append("\nIP Address......... ").append(pdu.getAgentAddress().toString());
        sbuf.append("\nEnterprise Id...... ").append(pdu.getEnterprise());
        sbuf.append("\nGeneric ........... ").append(pdu.getGenericTrap());
        sbuf.append("\nSpecific .......... ").append(pdu.getSpecificTrap());
        sbuf.append("\nTimeStamp ......... ").append(pdu.getTimestamp());
        sbuf.append("\n");
        Vector bindings = pdu.getVariableBindings();
        Iterator it = bindings.iterator();
        int counter = 0;
        while (it.hasNext()) {
            VariableBinding vb = (VariableBinding)it.next();
            if (vb == null) continue;
            sbuf.append("Varbind[").append(counter++).append("] := ");
            sbuf.append(vb.getOid().toString()).append(" --> ");
            sbuf.append(vb.getVariable().toString()).append("\n");
        }
        sbuf.append("\nLength............. ").append(counter);
        this.log.debug((Object)sbuf.toString());
    }
}

