/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.mc;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.FeatureMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.helpers.BeanMetaDataDeployerPlugin;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.metadata.api.annotations.Weld;
import org.jboss.kernel.weld.plugins.annotations.WeldEnabledBeanAnnotationPluginInitializer;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.mc.BeanMetaDataPropertyHolder;
import org.jboss.weld.integration.deployer.mc.IntermediateWeldBootstrapBean;

public class WeldBeanMetaDataDeployerPlugin
implements BeanMetaDataDeployerPlugin {
    public static int DEFAULT_ORDER = 50;
    private static final String ATTACHMENT = "Annotated_$_" + WeldBeanMetaDataDeployerPlugin.class.getName();
    private final int order;
    private final Map<Object, Object> intermediateBeans = new ConcurrentHashMap<Object, Object>();

    public WeldBeanMetaDataDeployerPlugin() {
        this(-1);
    }

    public WeldBeanMetaDataDeployerPlugin(int order) {
        this.order = order > 0 ? order : DEFAULT_ORDER;
    }

    public int getRelativeOrder() {
        return this.order;
    }

    public KernelControllerContext createContext(Controller controller, DeploymentUnit unit, BeanMetaData beanMetaData) {
        if (!DeployersUtils.isBootstrapBeanPresent((DeploymentUnit)unit)) {
            return null;
        }
        if (!this.isMcBeanWithWeldAnnotatedInjectionPoints(controller, unit, beanMetaData)) {
            return null;
        }
        String beanName = unit.getTopLevel().getName() + "BootstrapBeanInstaller=" + beanMetaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)IntermediateWeldBootstrapBean.class.getName());
        builder.addPropertyMetaData("bootstrapBean", builder.createInject((Object)DeployersUtils.getBootstrapBeanName((DeploymentUnit)unit), null, ControllerState.CONFIGURED, ControllerState.CREATE));
        builder.addPropertyMetaData("beanMetaDataHolder", (Object)new BeanMetaDataPropertyHolder(beanMetaData));
        builder.addPropertyMetaData("context", builder.createFromContextInject(FromContext.CONTEXT));
        builder.addPropertyMetaData("deployment", builder.createInject((Object)DeployersUtils.getDeploymentBeanName((DeploymentUnit)unit.getTopLevel())));
        builder.addPropertyMetaData("creator", builder.createValue((Object)this));
        AbstractKernelControllerContext ctx = new AbstractKernelControllerContext(null, builder.getBeanMetaData(), null);
        this.intermediateBeans.put(beanMetaData.getName(), beanName);
        return ctx;
    }

    private boolean isMcBeanWithWeldAnnotatedInjectionPoints(Controller controller, DeploymentUnit unit, BeanMetaData beanMetaData) {
        if (this.checkBeanMetaDataForWeldAnnotationOverridesOnInjectionPoints(controller, unit, beanMetaData)) {
            return true;
        }
        return this.checkAnnotationRepositoryForWeldAnnotationOnInjectionPoints(unit, beanMetaData);
    }

    private boolean checkBeanMetaDataForWeldAnnotationOverridesOnInjectionPoints(Controller controller, DeploymentUnit unit, BeanMetaData beanMetaData) {
        Set properties;
        ConstructorMetaData con = beanMetaData.getConstructor();
        if (con != null && this.hasWeldAnnotation(unit, (FeatureMetaData)con)) {
            return true;
        }
        List installs = beanMetaData.getInstalls();
        if (installs != null && installs.size() > 0) {
            for (InstallMetaData install : installs) {
                if (!this.hasWeldAnnotation(unit, (FeatureMetaData)install)) continue;
                return true;
            }
        }
        if ((properties = beanMetaData.getProperties()) != null && properties.size() > 0) {
            for (PropertyMetaData property : properties) {
                if (!this.hasWeldAnnotation(unit, (FeatureMetaData)property)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAnnotationRepositoryForWeldAnnotationOnInjectionPoints(DeploymentUnit unit, BeanMetaData beanMetaData) {
        while (unit.isComponent()) {
            unit = unit.getParent();
        }
        Set classNames = (Set)unit.getAttachment(ATTACHMENT);
        if (classNames == null) {
            AnnotationIndex index = (AnnotationIndex)unit.getAttachment(AnnotationIndex.class);
            if (index == null) {
                return false;
            }
            HashSet result = new HashSet(1);
            result.addAll(index.classHasConstructorAnnotatedWith(Weld.class));
            result.addAll(index.classHasFieldAnnotatedWith(Weld.class));
            result.addAll(index.classHasMethodAnnotatedWith(Weld.class));
            if (result.size() == 0) {
                classNames = Collections.emptySet();
            } else {
                classNames = new HashSet();
                for (Element item : result) {
                    classNames.add(item.getOwnerClassName());
                }
            }
            unit.addAttachment(ATTACHMENT, classNames);
        }
        try {
            return classNames.contains(beanMetaData.getBean());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasWeldAnnotation(DeploymentUnit unit, FeatureMetaData fmd) {
        Set anns = fmd.getAnnotations();
        if (anns != null && anns.size() > 0) {
            for (AnnotationMetaData ann : anns) {
                if (ann.getAnnotationInstance(unit.getClassLoader()).annotationType() != Weld.class) continue;
                return true;
            }
        }
        return false;
    }

    public boolean uninstallContext(Controller controller, DeploymentUnit unit, BeanMetaData beanMetaData) {
        Object intermediateBean = this.intermediateBeans.remove(beanMetaData.getName());
        if (intermediateBean != null && controller.getContext(intermediateBean, null) != null) {
            controller.uninstall(intermediateBean);
        }
        if (controller.getContext((Object)beanMetaData.getName(), null) != null) {
            controller.uninstall((Object)beanMetaData.getName());
        }
        return true;
    }

    public void removeIntermediateBean(String name) {
        this.intermediateBeans.remove(name);
    }

    static {
        WeldEnabledBeanAnnotationPluginInitializer.initialize();
    }
}

