/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.integration.deployer.env;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/**
 * Initial (naive) implementation of Deployment for JBoss AS.
 *
 * This version simply flattens the entire deployment into a single
 * BeanDeploymentArchive
 *
 * @author pmuir
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class FlatDeployment implements Deployment
{
   private final BeanDeploymentArchive beanDeploymentArchive;
   private final List<BeanDeploymentArchive> beanDeploymentArchives;
   private final ServiceRegistry services;

   public FlatDeployment(WeldDiscoveryEnvironment environment, Collection<EjbDescriptor<?>> ejbDescriptors)
   {
      this.beanDeploymentArchive = new JBossBeanDeploymentArchive("flat" ,environment, ejbDescriptors);
      this.beanDeploymentArchives = Collections.singletonList(beanDeploymentArchive);
      this.services = new SimpleServiceRegistry();
   }

   public List<BeanDeploymentArchive> getBeanDeploymentArchives()
   {
      return beanDeploymentArchives;
   }

   public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass)
   {
      return beanDeploymentArchive;
   }

   public BeanDeploymentArchive getFlatBeanDeploymentArchive()
   {
      return beanDeploymentArchive;
   }

   public ServiceRegistry getServices()
   {
      return services;
   }
}