/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import junit.framework.Test;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.jsf.NotWBJsfBean;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VirtualFile;

public class CLIsolationTestCase
extends AbstractWeldTest {
    public CLIsolationTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return CLIsolationTestCase.suite(CLIsolationTestCase.class);
    }

    protected void assertClassNotFound(String className, DeploymentUnit unit) throws Exception {
        ClassLoader cl = unit.getClassLoader();
        try {
            Class<?> clazz = cl.loadClass(className);
            CLIsolationTestCase.fail((String)("Should not be here: " + clazz.getClassLoader()));
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testIsolation(VirtualFile fst, String inFst, VirtualFile snd, String inSnd) throws Exception {
        VFSDeployment deployment1 = this.createVFSDeployment(fst);
        VFSDeployment deployment2 = this.createVFSDeployment(snd);
        DeployerClient mainDeployer = this.getDeployerClient();
        mainDeployer.addDeployment((Deployment)deployment1);
        mainDeployer.addDeployment((Deployment)deployment2);
        mainDeployer.process();
        try {
            DeploymentUnit du1 = this.getMainDeployerStructure().getDeploymentUnit(deployment1.getName());
            this.assertLoadClass(inFst, du1.getClassLoader());
            this.assertClassNotFound(inSnd, du1);
            DeploymentUnit du2 = this.getMainDeployerStructure().getDeploymentUnit(deployment2.getName());
            this.assertLoadClass(inSnd, du2.getClassLoader());
            this.assertClassNotFound(inFst, du2);
        }
        finally {
            mainDeployer.removeDeployment((Deployment)deployment2);
            mainDeployer.removeDeployment((Deployment)deployment1);
            mainDeployer.process();
        }
    }

    public void testTwoEars() throws Exception {
        VirtualFile ear1 = this.createTopLevelWithUtil("/weld/earwithutil");
        VirtualFile ear2 = this.createJarInEar();
        this.testIsolation(ear1, "org.jboss.test.deployers.support.util.SomeUtil", ear2, "org.jboss.test.deployers.support.jar.PlainJavaBean");
    }

    public void testTwoWars() throws Exception {
        VirtualFile war1 = this.createWar("w1.war", ServletWebBean.class);
        VirtualFile war2 = this.createWar("w2.war", NotWBJsfBean.class);
        this.testIsolation(war1, ServletWebBean.class.getName(), war2, NotWBJsfBean.class.getName());
    }

    public void testTwoJars() throws Exception {
        VirtualFile jar1 = this.createEjbJar("j1.jar", ServletWebBean.class);
        VirtualFile jar2 = this.createEjbJar("j2.jar", NotWBJsfBean.class);
        this.testIsolation(jar1, ServletWebBean.class.getName(), jar2, NotWBJsfBean.class.getName());
    }

    public void testWarEar() throws Exception {
        VirtualFile ear = this.createJarInEar();
        VirtualFile war = this.createWar("w1.war", ServletWebBean.class);
        this.testIsolation(ear, "org.jboss.test.deployers.support.jar.PlainJavaBean", war, ServletWebBean.class.getName());
    }

    public void testJarEar() throws Exception {
        VirtualFile ear = this.createJarInEar();
        VirtualFile jar = this.createEjbJar("j1.jar", ServletWebBean.class);
        this.testIsolation(ear, "org.jboss.test.deployers.support.jar.PlainJavaBean", jar, ServletWebBean.class.getName());
    }

    public void testJarWar() throws Exception {
        VirtualFile jar = this.createEjbJar("j1.jar", PlainJavaBean.class);
        VirtualFile war = this.createWar("w1.war", ServletWebBean.class);
        this.testIsolation(jar, PlainJavaBean.class.getName(), war, ServletWebBean.class.getName());
    }
}

