/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.BusinessInterface;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldDiscoveryEnvTestCase
extends AbstractWeldTest {
    public WeldDiscoveryEnvTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return WeldDiscoveryEnvTestCase.suite(WeldDiscoveryEnvTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleUsage() throws Exception {
        VirtualFile ear = this.createBasicEar();
        VFSDeploymentUnit topUnit = this.assertDeploy(ear);
        try {
            WeldDiscoveryEnvironment wbDiscovery = (WeldDiscoveryEnvironment)topUnit.getAttachment(WeldDiscoveryEnvironment.class);
            WeldDiscoveryEnvTestCase.assertNotNull((String)"Null WBDiscoveryEnv.", (Object)wbDiscovery);
            HashSet<String> expected = new HashSet<String>();
            WeldDiscoveryEnvTestCase.addExpectedResource(expected, "ejbs.jar");
            WeldDiscoveryEnvTestCase.addExpectedResource(expected, "ext.jar");
            WeldDiscoveryEnvTestCase.addExpectedResource(expected, "simple.jar");
            WeldDiscoveryEnvTestCase.addExpectedResource(expected, "ui.jar");
            WeldDiscoveryEnvTestCase.addExpectedResource(expected, "crm.jar");
            WeldDiscoveryEnvTestCase.addExpectedResource(expected, "simple.war", "/WEB-INF/beans.xml");
            WeldDiscoveryEnvTestCase.assertNotNull((Object)wbDiscovery);
            for (URL url : wbDiscovery.getWeldXml()) {
                boolean found = false;
                Iterator iter = expected.iterator();
                while (iter.hasNext()) {
                    String expectedURL = (String)iter.next();
                    if (!url.toExternalForm().contains(expectedURL)) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                WeldDiscoveryEnvTestCase.assertTrue((String)("Unexpected wb url: " + url), (boolean)found);
            }
            this.assertEmpty("Should be emtpy, missing " + expected, expected);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, BusinessInterface.class);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, MySLSBean.class);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, ExternalWebBean.class);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, PlainJavaBean.class);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, UIWebBean.class);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, ServletWebBean.class);
            WeldDiscoveryEnvTestCase.addExpectedClass(expected, CrmWebBean.class);
            for (Class clazz : wbDiscovery.getWeldClasses()) {
                WeldDiscoveryEnvTestCase.assertTrue((boolean)expected.remove(clazz.getName()));
            }
            this.assertEmpty("Should be emtpy, missing " + expected, expected);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.undeploy((DeploymentUnit)topUnit);
            throw throwable;
        }
        this.undeploy((DeploymentUnit)topUnit);
    }

    private static void addExpectedResource(Set<String> expected, String unit) {
        WeldDiscoveryEnvTestCase.addExpectedResource(expected, unit, "/META-INF/beans.xml");
    }

    private static void addExpectedResource(Set<String> expected, String unit, String suffix) {
        expected.add(unit + suffix);
    }

    private static void addExpectedClass(Set<String> expected, Class<?> clazz) {
        expected.add(clazz.getName());
    }
}

