/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.ArchiveToClasspath;
import org.jboss.weld.integration.deployer.env.bda.Classpath;
import org.jboss.weld.integration.deployer.env.bda.ClasspathFactory;

public class ArchiveInfo {
    private static final ClasspathFactory classpathFactory = ClasspathFactory.getInstance();
    private static final Map<ClassLoader, ArchiveInfo> instances = new WeakHashMap<ClassLoader, ArchiveInfo>();
    private ArchiveToClasspath classpathAdapter;
    private Classpath classpath;
    private ClassLoader classLoader;
    private final WeldDiscoveryEnvironment environment;

    public static final ArchiveInfo getInstance(ClassLoader classLoader) {
        return instances.get(classLoader);
    }

    public ArchiveInfo(ClassLoader classLoader) {
        instances.put(classLoader, this);
        this.classLoader = classLoader;
        this.classpath = classpathFactory.create(classLoader);
        this.environment = new WeldDiscoveryEnvironment();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public WeldDiscoveryEnvironment getEnvironment() {
        return this.environment;
    }

    ArchiveToClasspath getClasspathAdapter() {
        if (this.classpathAdapter == null) {
            this.classpathAdapter = new ArchiveToClasspath();
        }
        return this.classpathAdapter;
    }

    boolean hasClasspathAdapter() {
        return this.classpathAdapter != null;
    }

    void cleanUp() {
        instances.remove(this.classLoader);
    }

    public String toString() {
        return "ArchiveInfo[" + this.classLoader + "]";
    }
}

