/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.classloading.ResourceLookupProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveFactory;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryDiscoveryService {
    private ResourceLookupProvider<Module> provider;
    private Iterable<URL> excludedUrls;
    private Set<BeanDeploymentArchive> libs;
    private AtomicBoolean checked = new AtomicBoolean();

    public LibraryDiscoveryService(ResourceLookupProvider<Module> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        this.provider = provider;
    }

    public synchronized Set<BeanDeploymentArchive> getLibraries() throws Exception {
        if (this.libs == null || !this.checked.get()) {
            this.libs = new HashSet<BeanDeploymentArchive>();
            ArrayList<VirtualFile> excludedFiles = null;
            Map modules = this.provider.getMatchingModules();
            for (Map.Entry entry : modules.entrySet()) {
                ClassLoader cl;
                Set urls = (Set)entry.getValue();
                if (this.excludedUrls != null && excludedFiles == null) {
                    excludedFiles = new ArrayList<VirtualFile>();
                    for (URL eu : this.excludedUrls) {
                        excludedFiles.add(VFS.getChild((URL)eu));
                    }
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>();
                for (URL u : urls) {
                    VirtualFile vf = VFS.getChild((URL)u);
                    boolean include = true;
                    if (excludedFiles != null) {
                        for (VirtualFile ef : excludedFiles) {
                            if (!vf.getParentFileList().contains(ef)) continue;
                            include = false;
                            break;
                        }
                    }
                    if (!include) continue;
                    files.add(vf);
                }
                if (files.isEmpty() || (cl = SecurityActions.getClassLoaderForModule((Module)entry.getKey())) == null) continue;
                ArchiveInfo archiveInfo = new ArchiveInfo(cl);
                Archive archive = ArchiveFactory.createArchive(archiveInfo, new ArrayList());
                SimpleServiceRegistry serviceRegistry = new SimpleServiceRegistry();
                this.libs.add(archive.createBeanDeploymentArchive((ServiceRegistry)serviceRegistry));
                WeldDiscoveryEnvironment environment = archiveInfo.getEnvironment();
                ResourceVisitor visitor = environment.visitor();
                Module module = (Module)entry.getKey();
                for (VirtualFile child : files) {
                    URL beansXmlURL = child.getChild(this.provider.getResourceName()).toURL();
                    environment.addWeldXmlURL(beansXmlURL);
                    module.visit(visitor, (ResourceFilter)ClassFilter.INSTANCE, null, new URL[]{child.toURL()});
                }
            }
            this.checked.set(true);
        }
        return this.libs;
    }

    public synchronized void refresh() {
        this.checked.set(false);
    }

    public void setExcludedUrls(Iterable<URL> excludedUrls) {
        this.excludedUrls = excludedUrls;
    }
}

