/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.reloaded.naming.service.NameSpaces;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.weld.integration.deployer.DeployersUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJndiBinderDeployer<T>
extends AbstractDeployer {
    public static final String BEAN_MANAGER_JNDI_SUBCONTEXT = "BeanManagers";
    private Class<T> bootstrapClass;
    private Object thisName;
    private Hashtable<String, String> jndiEnvironment = new Hashtable();
    private Context beanManagerContext;
    private NameSpaces nameSpaces;

    protected AbstractJndiBinderDeployer(Class<T> bootstrapClass) {
        if (bootstrapClass == null) {
            throw new IllegalArgumentException("Null bootstrap class");
        }
        this.addInput(BeanMetaData.class);
        this.setStage(DeploymentStages.PRE_REAL);
        this.bootstrapClass = bootstrapClass;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        String bootstrapName = DeployersUtils.getBootstrapBeanName(unit);
        String bbAttachmentName = bootstrapName + "_" + BeanMetaData.class.getSimpleName();
        BeanMetaData bbBMD = (BeanMetaData)unit.getTopLevel().getAttachment(DeployersUtils.getBootstrapBeanAttachmentName(unit), BeanMetaData.class);
        if (bbBMD != null) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)bbBMD);
            ParameterMetaDataBuilder pmdb = builder.addInstallWithParameters("bind", this.thisName.toString(), ControllerState.INSTALLED, ControllerState.INSTALLED);
            pmdb.addParameterMetaData(this.bootstrapClass.getName(), builder.createThis());
            pmdb.addParameterMetaData(DeploymentUnit.class.getName(), (Object)unit);
            pmdb = builder.addUninstallWithParameters("unbind", this.thisName.toString(), ControllerState.INSTALLED, ControllerState.INSTALLED);
            pmdb.addParameterMetaData(this.bootstrapClass.getName(), builder.createThis());
            pmdb.addParameterMetaData(DeploymentUnit.class.getName(), (Object)unit);
        }
    }

    @Inject(fromContext=FromContext.NAME)
    public void setThisName(Object thisName) {
        this.thisName = thisName;
    }

    public void setNameSpaces(NameSpaces nameSpaces) {
        this.nameSpaces = nameSpaces;
    }

    protected Context createContext() throws NamingException {
        return this.nameSpaces.getGlobalContext();
    }

    public void create() throws Exception {
        if (this.jndiEnvironment != null) {
            AbstractJndiBinderDeployer.addNonSerializableFactory(this.jndiEnvironment);
        }
        Context context = this.createContext();
        this.beanManagerContext = context.createSubcontext(BEAN_MANAGER_JNDI_SUBCONTEXT);
    }

    protected Context getBeanManagerContext() {
        return this.beanManagerContext;
    }

    public void destroy() {
        try {
            Context context = this.createContext();
            context.destroySubcontext(BEAN_MANAGER_JNDI_SUBCONTEXT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setJndiEnvironment(Hashtable<String, String> jndiEnvironment) {
        this.jndiEnvironment = jndiEnvironment;
    }

    public abstract void bind(T var1, DeploymentUnit var2) throws NamingException;

    public abstract void unbind(T var1, DeploymentUnit var2) throws NamingException;

    protected static void addNonSerializableFactory(Hashtable<String, String> environment) {
        String nonSerializableFactory = NonSerializableFactory.class.getName();
        String objFactory = environment.get("java.naming.factory.object");
        objFactory = objFactory != null ? nonSerializableFactory + ":" + objFactory : nonSerializableFactory;
        environment.put("java.naming.factory.object", objFactory);
    }
}

