/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.integration.deployer.jndi.AbstractJndiBinderDeployer;
import org.jboss.weld.integration.deployer.jndi.BeanDeploymentArchiveLocator;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiBinderDeployer
extends AbstractJndiBinderDeployer<BootstrapBean> {
    private BeanDeploymentArchiveLocator beanDeploymentArchiveLocator;
    private JavaEEModuleInformer moduleInformer;

    public JndiBinderDeployer() {
        super(BootstrapBean.class);
        this.setWantComponents(false);
    }

    public void setBeanDeploymentArchiveLocator(BeanDeploymentArchiveLocator beanDeploymentArchiveLocator) {
        this.beanDeploymentArchiveLocator = beanDeploymentArchiveLocator;
    }

    public void setModuleInformer(JavaEEModuleInformer moduleInformer) {
        this.moduleInformer = moduleInformer;
    }

    @Override
    public void bind(BootstrapBean bootstrapBean, DeploymentUnit deploymentUnit) throws NamingException {
        BeanDeploymentArchive beanDeploymentArchive;
        Context context = this.getBeanManagerContext();
        if ((this.moduleInformer.getModuleType(deploymentUnit).equals((Object)JavaEEModuleInformer.ModuleType.EJB) || this.moduleInformer.getModuleType(deploymentUnit).equals((Object)JavaEEModuleInformer.ModuleType.WEB)) && (beanDeploymentArchive = this.beanDeploymentArchiveLocator.getBeanDeploymentArchive(bootstrapBean, deploymentUnit)) != null) {
            String applicationName = this.moduleInformer.getApplicationName(deploymentUnit);
            String name = applicationName == null ? "" : applicationName + "/";
            name = name + this.moduleInformer.getModulePath(deploymentUnit);
            NonSerializableFactory.rebind((Context)context, (String)name, (Object)bootstrapBean.getBootstrap().getManager(beanDeploymentArchive), (boolean)true);
        }
    }

    @Override
    public void unbind(BootstrapBean bootstrapBean, DeploymentUnit deploymentUnit) throws NamingException {
        Map<String, BeanManager> beanManagers = new DeploymentVisitor(bootstrapBean).visit().getBeanManagers();
        Context context = this.getBeanManagerContext();
        String applicationName = this.moduleInformer.getApplicationName(deploymentUnit);
        String topContext = applicationName != null ? applicationName : this.moduleInformer.getModulePath(deploymentUnit);
        try {
            Context appContext = (Context)context.lookup(topContext);
            context.destroySubcontext(topContext);
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DeploymentVisitor {
        private final Map<String, BeanManager> beanManagers = new HashMap<String, BeanManager>();
        private final BootstrapBean bootstrapBean;

        public DeploymentVisitor(BootstrapBean bootstrapBean) {
            this.bootstrapBean = bootstrapBean;
        }

        public Map<String, BeanManager> getBeanManagers() {
            return Collections.unmodifiableMap(this.beanManagers);
        }

        public DeploymentVisitor visit() {
            for (BeanDeploymentArchive bda : this.bootstrapBean.getDeployment().getBeanDeploymentArchives()) {
                this.visit(bda, new HashSet<BeanDeploymentArchive>());
            }
            return this;
        }

        private void visit(BeanDeploymentArchive bda, Set<BeanDeploymentArchive> seenBdas) {
            WeldManager beanManager = this.bootstrapBean.getBootstrap().getManager(bda);
            String key = beanManager.getId();
            this.beanManagers.put(key, (BeanManager)beanManager);
            seenBdas.add(bda);
            for (BeanDeploymentArchive child : bda.getBeanDeploymentArchives()) {
                if (seenBdas.contains(child)) continue;
                this.visit(child, seenBdas);
            }
        }
    }
}

