/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.integration.ejb.JBossBussinessInterfaceDescriptorAdaptor;
import org.jboss.weld.integration.ejb.JBossEJBDescriptorAdaptor;
import org.jboss.weld.integration.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSessionBeanDescriptorAdaptor<T>
extends JBossEJBDescriptorAdaptor<T>
implements EjbDescriptor<T> {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final List<BusinessInterfaceDescriptor<?>> localBusinessInterfaces = new ArrayList();
    private final List<Method> removeMethods;
    private final boolean stateful;
    private final boolean stateless;
    private final boolean singleton;
    private final String localJndiName;
    private final DeploymentUnit deploymentUnit;

    public JBossSessionBeanDescriptorAdaptor(JBossSessionBeanMetaData sessionBeanMetaData, DeploymentUnit deploymentUnit, EjbReferenceResolver resolver) {
        this(sessionBeanMetaData, deploymentUnit, resolver, sessionBeanMetaData.getLocalJndiName());
    }

    public JBossSessionBeanDescriptorAdaptor(JBossSessionBeanMetaData sessionBeanMetaData, DeploymentUnit deploymentUnit, EjbReferenceResolver resolver, String jndiName) {
        super((JBossEnterpriseBeanMetaData)sessionBeanMetaData, deploymentUnit, resolver);
        if (sessionBeanMetaData.getBusinessLocals() != null) {
            for (String interfaceName : sessionBeanMetaData.getBusinessLocals()) {
                this.localBusinessInterfaces.add(new JBossBussinessInterfaceDescriptorAdaptor(interfaceName, this.getEjbName(), deploymentUnit, resolver));
            }
        }
        this.removeMethods = new ArrayList<Method>();
        if (sessionBeanMetaData.getRemoveMethods() != null) {
            for (RemoveMethodMetaData removeMethodMetaData : sessionBeanMetaData.getRemoveMethods()) {
                try {
                    MethodParametersMetaData methodParameters = removeMethodMetaData.getBeanMethod().getMethodParams();
                    ArrayList parameterTypes = new ArrayList();
                    for (String methodParameter : methodParameters) {
                        try {
                            parameterTypes.add(Reflections.classForName(methodParameter, deploymentUnit.getClassLoader()));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Cannot load EJB remove method parameter class interface for " + removeMethodMetaData.toString(), e);
                        }
                    }
                    Method removeMethod = this.getBeanClass().getMethod(removeMethodMetaData.getBeanMethod().getMethodName(), parameterTypes.toArray(EMPTY_CLASS_ARRAY));
                    this.removeMethods.add(removeMethod);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Unable to access EJB remove method", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Unable to access EJB remove method", e);
                }
            }
        }
        this.stateful = sessionBeanMetaData.isStateful();
        this.stateless = sessionBeanMetaData.isStateless();
        this.singleton = false;
        this.localJndiName = jndiName;
        this.deploymentUnit = deploymentUnit;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localBusinessInterfaces;
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public boolean isMessageDriven() {
        return false;
    }

    public String getLocalJndiName() {
        return this.localJndiName;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnit;
    }

    public boolean isNoInterfaceView() {
        return false;
    }
}

