/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.ejb.interceptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingInterceptorInvocationContext
implements InvocationContext {
    private InvocationContext delegateInvocationContext;
    private Queue<Interceptor> invocationQueue;
    private Queue<Object> interceptorInstances;
    private InterceptionType interceptionType;

    public DelegatingInterceptorInvocationContext(InvocationContext delegateInvocationContext, List<Interceptor<?>> interceptors, List<Object> instances, InterceptionType interceptionType) {
        this.delegateInvocationContext = delegateInvocationContext;
        this.interceptionType = interceptionType;
        this.invocationQueue = new ConcurrentLinkedQueue(interceptors);
        this.interceptorInstances = new ConcurrentLinkedQueue<Object>(instances);
    }

    public Map<String, Object> getContextData() {
        return this.delegateInvocationContext.getContextData();
    }

    public Method getMethod() {
        return this.delegateInvocationContext.getMethod();
    }

    public Object[] getParameters() {
        return this.delegateInvocationContext.getParameters();
    }

    public Object getTarget() {
        return this.delegateInvocationContext.getTarget();
    }

    public Object proceed() throws Exception {
        if (!this.invocationQueue.isEmpty()) {
            return this.invocationQueue.remove().intercept(this.interceptionType, this.interceptorInstances.remove(), (InvocationContext)this);
        }
        return this.delegateInvocationContext.proceed();
    }

    public void setParameters(Object[] params) {
        this.delegateInvocationContext.setParameters(params);
    }

    public Object getTimer() {
        throw new UnsupportedOperationException("Get timer not supported");
    }
}

