/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.ejb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.integration.ejb.JBossEJBDescriptorAdaptor;
import org.jboss.weld.integration.ejb.JBossMessageDrivenBeanDescriptorAdaptor;
import org.jboss.weld.integration.ejb.JBossSessionBean31DescriptorAdaptor;
import org.jboss.weld.integration.ejb.JBossSessionBeanDescriptorAdaptor;
import org.jboss.weld.integration.ejb.JBossSessionObjectReference;
import org.jboss.weld.integration.util.AbstractJBossServices;
import org.jboss.weld.integration.vdf.DeploymentUnitAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossEjbServices
extends AbstractJBossServices
implements EjbServices,
DeploymentUnitAware {
    protected EjbReferenceResolver resolver;
    private final List<EjbDescriptor<?>> ejbs = new ArrayList();
    private final List<String> ejbContainerNames = new ArrayList<String>();
    private Map<EjbDescriptor<?>, InterceptorBindings> interceptorBindings = new ConcurrentHashMap();

    public void setResolver(EjbReferenceResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit du) {
        super.setDeploymentUnit(du);
        this.discoverEjbs(du.getTopLevel());
    }

    public SessionObjectReference resolveEjb(EjbDescriptor<?> ejbDescriptor) {
        try {
            return new JBossSessionObjectReference(ejbDescriptor, this.context);
        }
        catch (NamingException e) {
            throw new RuntimeException("Error retreiving EJB from JNDI " + ejbDescriptor, e);
        }
    }

    public void registerInterceptors(EjbDescriptor<?> ejbDescriptor, InterceptorBindings interceptorBindings) {
        this.interceptorBindings.put(ejbDescriptor, interceptorBindings);
    }

    public Object resolveRemoteEjb(String jndiName, String mappedName, String ejbLink) {
        if (mappedName != null) {
            try {
                return this.context.lookup(mappedName);
            }
            catch (NamingException e) {
                throw new RuntimeException("Error retreiving EJB from JNDI with mappedName " + mappedName, e);
            }
        }
        if (jndiName != null) {
            try {
                return this.context.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException("Error retreiving EJB from JNDI with mappedName " + jndiName, e);
            }
        }
        throw new IllegalArgumentException("jndiName, mappedName and ejbLink are null");
    }

    protected void discoverEjbs(DeploymentUnit du) {
        List children;
        if (du.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class) != null && ((JBossMetaData)du.getAttachment(JBossMetaData.class)).isEJB3x()) {
            JBossMetaData jBossMetaData = (JBossMetaData)du.getAttachment(JBossMetaData.class);
            for (JBossEnterpriseBeanMetaData enterpriseBeanMetaData : jBossMetaData.getEnterpriseBeans()) {
                JBossEJBDescriptorAdaptor ejbDescriptor;
                JBossSessionBean31MetaData sessionBeanMetaData;
                if (enterpriseBeanMetaData.isSession() && enterpriseBeanMetaData instanceof JBossSessionBean31MetaData) {
                    sessionBeanMetaData = (JBossSessionBean31MetaData)enterpriseBeanMetaData;
                    ejbDescriptor = new JBossSessionBean31DescriptorAdaptor(sessionBeanMetaData, du, this.resolver);
                    this.ejbs.add(ejbDescriptor);
                } else if (enterpriseBeanMetaData.isSession()) {
                    sessionBeanMetaData = (JBossSessionBeanMetaData)enterpriseBeanMetaData;
                    ejbDescriptor = new JBossSessionBeanDescriptorAdaptor((JBossSessionBeanMetaData)sessionBeanMetaData, du, this.resolver);
                    this.ejbs.add(ejbDescriptor);
                } else if (enterpriseBeanMetaData.isMessageDriven()) {
                    JBossMessageDrivenBeanMetaData messageDrivenBeanMetaData = (JBossMessageDrivenBeanMetaData)enterpriseBeanMetaData;
                    ejbDescriptor = new JBossMessageDrivenBeanDescriptorAdaptor(messageDrivenBeanMetaData, du, this.resolver);
                    this.ejbs.add(ejbDescriptor);
                }
                if (enterpriseBeanMetaData.getContainerName() != null) {
                    this.ejbContainerNames.add(enterpriseBeanMetaData.getContainerName());
                    continue;
                }
                this.ejbContainerNames.add(enterpriseBeanMetaData.getGeneratedContainerName());
            }
        }
        if ((children = du.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentUnit childDu : children) {
                this.discoverEjbs(childDu);
            }
        }
    }

    public Iterable<EjbDescriptor<?>> getEjbs() {
        return this.ejbs;
    }

    public Iterable<String> getEjbContainerNames() {
        return Collections.unmodifiableCollection(this.ejbContainerNames);
    }

    public InterceptorBindings getInterceptorBindings(EjbDescriptor<?> ejbDescriptor) {
        return this.interceptorBindings.get(ejbDescriptor);
    }

    @Override
    public void cleanup() {
        this.ejbContainerNames.clear();
        this.ejbs.clear();
        this.resolver = null;
    }
}

