/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.persistence;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.deployment.PersistenceUnitDeployment;
import org.jboss.jpa.injection.InjectedEntityManagerFactory;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.jpa.tx.TransactionScopedEntityManager;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.integration.util.AbstractJBossServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossJpaServices
extends AbstractJBossServices
implements JpaInjectionServices {
    protected PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;

    public void setPersistenceUnitDependencyResolver(PersistenceUnitDependencyResolver persistenceUnitDependencyResolver) {
        this.persistenceUnitDependencyResolver = persistenceUnitDependencyResolver;
    }

    public Collection<Class<?>> discoverEntities() {
        return Collections.emptyList();
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        if (!injectionPoint.getAnnotated().isAnnotationPresent(PersistenceContext.class)) {
            throw new IllegalArgumentException("No @PersistenceContext annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        try {
            String persistenceUnitName = ((PersistenceContext)injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class)).unitName();
            return new TransactionScopedEntityManager(this.lookupPersistenceUnitDeployment(persistenceUnitName).getManagedFactory());
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Unable to resolve persistence context for " + injectionPoint);
        }
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        if (!injectionPoint.getAnnotated().isAnnotationPresent(PersistenceUnit.class)) {
            throw new IllegalArgumentException("No @PersistenceUnit annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        try {
            return this.resolvePersistenceUnit(((PersistenceUnit)injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class)).unitName());
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Unable to resolve persistence context for " + injectionPoint);
        }
    }

    private EntityManagerFactory resolvePersistenceUnit(String unitName) {
        PersistenceUnitDeployment deployment = this.lookupPersistenceUnitDeployment(unitName);
        ManagedEntityManagerFactory managedFactory = deployment.getManagedFactory();
        return new InjectedEntityManagerFactory(managedFactory);
    }

    private PersistenceUnitDeployment lookupPersistenceUnitDeployment(String unitName) {
        if (unitName == null) {
            throw new IllegalArgumentException("unitName is null");
        }
        String beanName = JBossJpaServices.getPersistenceUnitSupplier(this.topLevelDeploymentUnit, this.persistenceUnitDependencyResolver, unitName);
        if (beanName == null) {
            throw new IllegalStateException("No persistence unit available for " + unitName);
        }
        return this.jbossEjb.lookupPersistenceUnitDeployment(beanName);
    }

    private static String getPersistenceUnitSupplier(DeploymentUnit deploymentUnit, PersistenceUnitDependencyResolver persistenceUnitDependencyResolver, String persistenceUnitName) {
        if (deploymentUnit.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class) != null && ((JBossMetaData)deploymentUnit.getAttachment(JBossMetaData.class)).isEJB3x() || deploymentUnit.getAttachment(JBossWebMetaData.class) != null) {
            try {
                return persistenceUnitDependencyResolver.resolvePersistenceUnitSupplier(deploymentUnit, persistenceUnitName);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        for (DeploymentUnit child : deploymentUnit.getChildren()) {
            String beanName = JBossJpaServices.getPersistenceUnitSupplier(child, persistenceUnitDependencyResolver, persistenceUnitName);
            if (beanName == null) continue;
            return beanName;
        }
        return null;
    }
}

