/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossset.bugclerk.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.jbossset.bugclerk.BugClerk;
import org.jboss.jbossset.bugclerk.BugclerkConfiguration;
import org.jboss.jbossset.bugclerk.aphrodite.AphroditeClient;
import org.jboss.jbossset.bugclerk.cli.BugClerkArguments;
import org.jboss.jbossset.bugclerk.cli.CommandLineInterfaceUtils;
import org.jboss.jbossset.bugclerk.cli.CommonArguments;

public final class BugClerkCLI {
    private static final int PROGRAM_THROWN_EXCEPTION = 3;

    private BugClerkCLI() {
    }

    public static void main(String[] args) {
        try {
            BugClerkArguments arguments = CommandLineInterfaceUtils.extractParameters(new BugClerkArguments(), args);
            if (arguments.getIds().isEmpty()) {
                throw new IllegalArgumentException("No IDs provided.");
            }
            AphroditeClient aphrodite = new AphroditeClient();
            arguments.setIssues(aphrodite.loadIssues(arguments.getIds()));
            BugClerkArguments validatedArgs = BugClerkArguments.validateArgs(arguments);
            new BugClerk(aphrodite, BugClerkCLI.instantiateConfiguration(validatedArgs)).runAndReturnsViolations(validatedArgs.getIssues());
            aphrodite.close();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            if (t.getCause() != null) {
                System.out.println(t.getCause().getMessage());
            }
            System.exit(3);
        }
    }

    private static Collection<String> extractChecknamesFromArgs(CommonArguments arguments) {
        return !"".equals(arguments.getChecknames()) ? Arrays.asList(arguments.getChecknames().split(",")) : new ArrayList(0);
    }

    public static BugclerkConfiguration instantiateConfiguration(CommonArguments arguments) {
        BugclerkConfiguration configuration = new BugclerkConfiguration();
        configuration.setDebug(arguments.isDebug());
        configuration.setFailOnViolation(arguments.isFailOnViolation());
        configuration.setHtmlReportFilename(arguments.getHtmlReportFilename());
        configuration.setXmlReportFilename(arguments.getXmlReportFilename());
        configuration.setReportViolation(arguments.isReportToBz());
        configuration.setChecknames(BugClerkCLI.extractChecknamesFromArgs(arguments));
        return configuration;
    }
}

