/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossset.bugclerk.cli;

import java.net.MalformedURLException;
import java.util.List;
import org.jboss.jbossset.bugclerk.BugClerk;
import org.jboss.jbossset.bugclerk.aphrodite.AphroditeClient;
import org.jboss.jbossset.bugclerk.cli.BugClerkArguments;
import org.jboss.jbossset.bugclerk.cli.BugClerkCLI;
import org.jboss.jbossset.bugclerk.cli.BugClerkInvocatioWithFilterArguments;
import org.jboss.jbossset.bugclerk.cli.CommandLineInterfaceUtils;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public final class BugClerkWithFilterCLI {
    private BugClerkWithFilterCLI() {
    }

    public static void main(String[] args) throws MalformedURLException, AphroditeException, NotFoundException {
        AphroditeClient client = new AphroditeClient();
        BugClerkInvocatioWithFilterArguments arguments = CommandLineInterfaceUtils.extractParameters(new BugClerkInvocatioWithFilterArguments(), args);
        List issues = client.retrievePayload(arguments.getFilterURL());
        if (!issues.isEmpty()) {
            BugClerkWithFilterCLI.endProgram(arguments, BugClerkWithFilterCLI.runBugClerk(issues, client, arguments));
        }
        client.close();
    }

    private static void endProgram(BugClerkInvocatioWithFilterArguments arguments, int nbViolation) {
        int status = 0;
        if (arguments.isFailOnViolation()) {
            status = nbViolation;
        }
        if (status != 0) {
            System.exit(status);
        }
    }

    private static int runBugClerk(List<Issue> issues, AphroditeClient aphrodite, BugClerkInvocatioWithFilterArguments arguments) {
        return new BugClerk(aphrodite, BugClerkCLI.instantiateConfiguration(BugClerkWithFilterCLI.buildArgumentsFrom(arguments))).runAndReturnsViolations(issues);
    }

    private static BugClerkArguments buildArgumentsFrom(BugClerkInvocatioWithFilterArguments arguments) {
        BugClerkArguments bcArgs = new BugClerkArguments();
        bcArgs.setReportToBz(arguments.isReportToBz());
        bcArgs.setXmlReportFilename(arguments.getXmlReportFilename());
        bcArgs.setHtmlReportFilename(arguments.getHtmlReportFilename());
        bcArgs.setChecknames(arguments.getChecknames());
        return bcArgs;
    }
}

