/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.overview;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.api.BasicCacheContainer;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.logging.Logger;

@ApplicationScoped
public class CacheContainerProvider {
    private static final Logger LOGGER = Logger.getLogger(CacheContainerProvider.class);
    private BasicCacheContainer manager;

    public BasicCacheContainer getCacheContainer() {
        if (this.manager == null) {
            GlobalConfiguration glob = new GlobalConfigurationBuilder().nonClusteredDefault().globalJmxStatistics().enable().jmxDomain("overview").build();
            Configuration loc = new ConfigurationBuilder().clustering().cacheMode(CacheMode.LOCAL).eviction().maxEntries(500).strategy(EvictionStrategy.LIRS).loaders().passivation(false).locking().concurrencyLevel(16).build();
            this.manager = new DefaultCacheManager(glob, loc, true);
            LOGGER.info((Object)"=== Using DefaultCacheManager (library mode) ===");
        }
        return this.manager;
    }

    @PreDestroy
    public void cleanUp() {
        this.manager.stop();
        this.manager = null;
    }
}

