/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.overview;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.eclipse.egit.github.core.PullRequest;
import org.infinispan.api.BasicCache;
import org.jboss.logging.Logger;
import org.jboss.overview.CacheContainerProvider;
import org.jboss.overview.DataTableScrollerBean;
import org.jboss.overview.SingletonAider;
import org.jboss.overview.model.OverviewData;
import org.jboss.pull.shared.BuildResult;
import org.jboss.pull.shared.ProcessorPullState;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.evaluators.BasePullEvaluator;
import org.jboss.pull.shared.spi.PullEvaluator;
import org.richfaces.application.push.MessageException;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class SingletonAider {
    private final Logger LOGGER = Logger.getLogger(SingletonAider.class);
    private final String PULL_REQUEST_STATE = "open";
    private static final String CACHE_NAME = "cache";
    private PullHelper helper;
    private final long DELAY = 15L;
    private final long PERIOD = 60L;
    @Inject
    private CacheContainerProvider provider;
    private BasicCache<Integer, OverviewData> cache;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);

    @PostConstruct
    public void postConstruct() {
        this.LOGGER.debug((Object)("pull.helper.property.file: " + System.getProperty("pull.helper.property.file")));
        try {
            this.helper = new PullHelper("pull.helper.property.file", "./processor.properties");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        this.cache = this.provider.getCacheContainer().getCache(CACHE_NAME);
        this.executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.scheduler.scheduleAtFixedRate((Runnable)new TaskThread(this), 15L, 60L, TimeUnit.MINUTES);
    }

    @Lock(value=LockType.WRITE)
    public void initCache() {
        List pullRequests = this.helper.getGHHelper().getPullRequests("open");
        for (PullRequest pullRequest : pullRequests) {
            OverviewData pullRequestData = this.getOverviewData(pullRequest);
            this.cache.put((Object)pullRequest.getNumber(), (Object)pullRequestData, -1L, TimeUnit.SECONDS);
            try {
                DataTableScrollerBean.push();
            }
            catch (MessageException e) {
                e.printStackTrace(System.err);
            }
        }
        this.LOGGER.info((Object)"cache initialization completed.");
    }

    public OverviewData getOverviewData(PullRequest pullRequest) {
        BuildResult buildResult = this.helper.checkBuildResult(pullRequest);
        List upStreamPullRequests = this.helper.getEvaluatorFacade().getUpstreamPullRequest(pullRequest);
        List bugs = this.helper.getEvaluatorFacade().getIssue(pullRequest);
        PullEvaluator.Result mergeable = this.helper.getEvaluatorFacade().isMergeable(pullRequest);
        boolean isReviewed = BasePullEvaluator.isReviewed((PullEvaluator.Result)mergeable);
        ProcessorPullState pullState = this.helper.checkPullRequestState(pullRequest);
        List overallState = mergeable.getDescription();
        return new OverviewData(pullRequest, buildResult, upStreamPullRequests, bugs, overallState, mergeable.isMergeable(), isReviewed, pullState);
    }

    @Lock(value=LockType.WRITE)
    public void updateCache() {
        Set keys = this.cache.keySet();
        List pullRequests = this.helper.getGHHelper().getPullRequests("open");
        HashMap<Integer, PullRequest> pullRequestsMap = new HashMap<Integer, PullRequest>();
        for (PullRequest pullRequest : pullRequests) {
            pullRequestsMap.put(pullRequest.getNumber(), pullRequest);
        }
        Set ids = pullRequestsMap.keySet();
        for (Integer key : keys) {
            if (ids.contains(key)) continue;
            this.cache.remove((Object)key);
            try {
                DataTableScrollerBean.push();
            }
            catch (MessageException e) {
                e.printStackTrace(System.err);
            }
        }
        keys = this.cache.keySet();
        for (Integer key : keys) {
            this.cache.replace((Object)key, this.cache.get((Object)key), (Object)this.getOverviewData((PullRequest)pullRequestsMap.get(key)));
            try {
                DataTableScrollerBean.push();
            }
            catch (MessageException e) {
                e.printStackTrace(System.err);
            }
        }
        for (Integer id : ids) {
            if (keys.contains(id)) continue;
            OverviewData overviewData = this.getOverviewData((PullRequest)pullRequestsMap.get(id));
            this.cache.put((Object)id, (Object)overviewData);
            try {
                DataTableScrollerBean.push();
            }
            catch (MessageException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public PullHelper getHelper() {
        return this.helper;
    }

    @Lock(value=LockType.READ)
    @AccessTimeout(value=4L, unit=TimeUnit.SECONDS)
    public BasicCache<Integer, OverviewData> getCache() {
        return this.cache;
    }
}

