/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.SynchronizationRecord;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class TwoPhaseCoordinator
extends BasicAction
implements Reapable {
    private SortedSet _synchs;
    private SynchronizationRecord _currentRecord;
    private Throwable _deferredThrowable;

    public TwoPhaseCoordinator() {
    }

    public TwoPhaseCoordinator(Uid id) {
        super(id);
    }

    public int start() {
        return this.start(BasicAction.Current());
    }

    public int start(BasicAction parentAction) {
        int status = 9;
        if (parentAction != null) {
            parentAction.addChildAction(this);
        }
        return super.Begin(parentAction);
    }

    public int end(boolean report_heuristics) {
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        int outcome = this.beforeCompletion() ? super.End(report_heuristics) : super.Abort();
        this.afterCompletion(outcome);
        return outcome;
    }

    public int cancel() {
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        int outcome = super.Abort();
        this.afterCompletion(outcome);
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSynchronization(SynchronizationRecord sr) {
        if (sr == null) {
            return 3;
        }
        int result = 3;
        if (this.parent() != null) {
            return 3;
        }
        switch (this.status()) {
            case 0: {
                Comparable c;
                TwoPhaseCoordinator twoPhaseCoordinator = this;
                synchronized (twoPhaseCoordinator) {
                    if (this._synchs == null) {
                        this._synchs = new TreeSet();
                    }
                }
                if (sr instanceof Comparable && this._currentRecord != null && (c = (Comparable)((Object)sr)).compareTo(this._currentRecord) != 1) {
                    return 3;
                }
                if (!this._synchs.add(sr)) break;
                result = 2;
                break;
            }
        }
        return result;
    }

    public boolean running() {
        return this.status() == 0;
    }

    public String type() {
        return "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator";
    }

    public Throwable getDeferredThrowable() {
        return this._deferredThrowable;
    }

    protected TwoPhaseCoordinator(int at) {
        super(at);
    }

    protected TwoPhaseCoordinator(Uid u, int at) {
        super(u, at);
    }

    protected boolean beforeCompletion() {
        boolean problem = false;
        if (this._synchs != null) {
            int lastIndexProcessed = -1;
            SynchronizationRecord[] copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
            while (lastIndexProcessed < this._synchs.size() - 1 && !problem) {
                if (copiedSynchs.length != this._synchs.size()) {
                    copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                }
                this._currentRecord = copiedSynchs[++lastIndexProcessed];
                try {
                    problem = !this._currentRecord.beforeCompletion();
                }
                catch (Exception ex) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_2", new Object[]{this._currentRecord}, (Throwable)ex);
                    if (this._deferredThrowable == null) {
                        this._deferredThrowable = ex;
                    }
                    problem = true;
                }
                catch (Error er) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_2", new Object[]{this._currentRecord}, (Throwable)er);
                    if (this._deferredThrowable == null) {
                        this._deferredThrowable = er;
                    }
                    problem = true;
                }
            }
            if (problem && !this.preventCommit()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_1");
            }
        }
        return !problem;
    }

    protected boolean afterCompletion(int myStatus) {
        if (myStatus == 0) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_3");
            return false;
        }
        boolean problem = false;
        if (this._synchs != null) {
            Stack stack = new Stack();
            Iterator iterator = this._synchs.iterator();
            while (iterator.hasNext()) {
                stack.push(iterator.next());
            }
            iterator = stack.iterator();
            while (!stack.isEmpty()) {
                SynchronizationRecord record = (SynchronizationRecord)stack.pop();
                try {
                    if (record.afterCompletion(myStatus)) continue;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4", new Object[]{record});
                    problem = true;
                }
                catch (Exception ex) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4a", new Object[]{record, ex});
                    problem = true;
                }
                catch (Error er) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4b", new Object[]{record, er});
                    problem = true;
                }
            }
            this._synchs = null;
            this._currentRecord = null;
        }
        return !problem;
    }
}

